/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.SyntaxUtils;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;

@Cli(name="domain", description="Display or set current selected domain. ", note="With a parameter, parameter defined domain is selected, otherwise it displays current selected domain. eg. domain java.lang")
public class DomainCommand
extends Command {
    private String domain;

    static String getDomainName(String domain, Session session) throws IOException {
        Validate.notNull((Object)session, (String)"Session can't be NULL", (Object[])new Object[0]);
        Validate.isTrue((session.getConnection() != null ? 1 : 0) != 0, (String)"Session isn't opened", (Object[])new Object[0]);
        if (domain == null) {
            return session.getDomain();
        }
        if (SyntaxUtils.isNull(domain)) {
            return null;
        }
        HashSet<String> domains = new HashSet<String>(DomainsCommand.getCandidateDomains(session));
        if (!domains.contains(domain)) {
            throw new IllegalArgumentException("Domain " + domain + " doesn't exist, check your spelling");
        }
        return domain;
    }

    @Override
    public List<String> doSuggestArgument() throws IOException {
        return DomainsCommand.getCandidateDomains(this.getSession());
    }

    @Override
    public void execute() throws IOException {
        Session session = this.getSession();
        if (this.domain == null) {
            if (session.getDomain() == null) {
                session.output.printMessage("domain is not set");
                session.output.println("null");
            } else {
                session.output.printMessage("domain = " + session.getDomain());
                session.output.println(session.getDomain());
            }
            return;
        }
        String domainName = DomainCommand.getDomainName(this.domain, session);
        if (domainName == null) {
            session.unsetDomain();
            session.output.printMessage("domain is unset");
        } else {
            session.setDomain(domainName);
            session.output.printMessage("domain is set to " + session.getDomain());
        }
    }

    @Argument(displayName="domain", description="Name of domain to set")
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

