/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.cyclopsgroup.jmxterm.io.CommandOutput;

public class ValueOutputFormat {
    private final int indentSize;
    private final boolean showDescription;
    private final boolean showQuotationMarks;

    public ValueOutputFormat() {
        this(2, true, true);
    }

    public ValueOutputFormat(int indentSize, boolean showDescription, boolean showQuotationMarks) {
        Validate.isTrue((indentSize >= 0 ? 1 : 0) != 0, (String)("Invalid indent size value " + indentSize), (Object[])new Object[0]);
        this.indentSize = indentSize;
        this.showDescription = showDescription;
        this.showQuotationMarks = showQuotationMarks;
    }

    public void printExpression(CommandOutput output, Object name, Object value, String description) {
        this.printExpression(output, name, value, description, 0);
    }

    private void printExpression(CommandOutput output, Object name, Object value, String description, int indent) {
        output.print(StringUtils.repeat((String)" ", (int)indent));
        this.printValue(output, name, indent);
        output.print(" = ");
        this.printValue(output, value, indent);
        output.print(";");
        if (this.showDescription && description != null) {
            output.print(" (" + description + ")");
        }
        output.println("");
    }

    public void printValue(CommandOutput output, Object value) {
        this.printValue(output, value, 0);
    }

    private void printValue(CommandOutput output, Object value, int indent) {
        if (value == null) {
            output.print("null");
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            output.print("[ ");
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    output.print(", ");
                }
                this.printValue(output, Array.get(value, i), indent);
            }
            output.print(" ]");
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            boolean start = true;
            output.print("( ");
            for (Object obj : (Collection)value) {
                if (!start) {
                    output.print(", ");
                }
                start = false;
                this.printValue(output, obj, indent);
            }
            output.print(" )");
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            output.println("{ ");
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.printExpression(output, entry.getKey(), entry.getValue(), null, indent + this.indentSize);
            }
            output.print(StringUtils.repeat((String)" ", (int)indent) + " }");
        } else if (CompositeData.class.isAssignableFrom(value.getClass())) {
            output.println("{ ");
            CompositeData data = (CompositeData)value;
            for (String key : data.getCompositeType().keySet()) {
                Object v = data.get(key);
                this.printExpression(output, key, v, data.getCompositeType().getDescription(key), indent + this.indentSize);
            }
            output.print(StringUtils.repeat((String)" ", (int)indent) + " }");
        } else if (value instanceof String && this.showQuotationMarks) {
            output.print("\"" + value + "\"");
        } else {
            output.print(value.toString());
        }
    }
}

