/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.lang3.Validate;

public final class WeakCastUtils {
    public static Object cast(final Object from, Class<?>[] interfaces, ClassLoader classLoader) throws SecurityException, NoSuchMethodException {
        Validate.notNull((Object)from, (String)"Invocation target can't be NULL", (Object[])new Object[0]);
        Validate.notNull(interfaces, (String)"Interfaces can't be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)classLoader, (String)"ClassLoader can't be NULL", (Object[])new Object[0]);
        final HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Class<?> interfase : interfaces) {
            Validate.isTrue((boolean)interfase.isInterface(), (String)(interfase + " is not an interface"), (Object[])new Object[0]);
            for (Method fromMethod : interfase.getMethods()) {
                Method toMethod = from.getClass().getMethod(fromMethod.getName(), fromMethod.getParameterTypes());
                methodMap.put(fromMethod, toMethod);
            }
        }
        return Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method toMethod = (Method)methodMap.get(method);
                if (toMethod == null) {
                    throw new OperationNotSupportedException("Method " + method + " isn't implemented in " + from.getClass());
                }
                try {
                    if ((toMethod.getModifiers() & 8) == 0) {
                        return toMethod.invoke(from, args);
                    }
                    return toMethod.invoke(null, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    public static <T> T cast(Object from, Class<T> interfase) throws SecurityException, NoSuchMethodException {
        return WeakCastUtils.cast(from, interfase, interfase.getClassLoader());
    }

    public static <T> T cast(Object from, Class<T> interfase, ClassLoader classLoader) throws SecurityException, NoSuchMethodException {
        Validate.notNull(interfase, (String)"Interface can't be NULL", (Object[])new Object[0]);
        return (T)WeakCastUtils.cast(from, new Class[]{interfase}, classLoader);
    }

    public static Object staticCast(final Class<?> from, Class<?>[] interfaces, ClassLoader classLoader) throws SecurityException, NoSuchMethodException {
        Validate.notNull(from, (String)"Invocation target type can't be NULL", (Object[])new Object[0]);
        Validate.notNull(interfaces, (String)"Interfaces can't be NULL", (Object[])new Object[0]);
        Validate.notNull((Object)classLoader, (String)"ClassLoader can't be NULL", (Object[])new Object[0]);
        final HashMap<Method, Method> methodMap = new HashMap<Method, Method>();
        for (Class<?> interfase : interfaces) {
            Validate.isTrue((boolean)interfase.isInterface(), (String)(interfase + " is not an interface"), (Object[])new Object[0]);
            for (Method fromMethod : interfase.getMethods()) {
                Method toMethod = from.getMethod(fromMethod.getName(), fromMethod.getParameterTypes());
                if ((toMethod.getModifiers() & 8) == 0) {
                    throw new NoSuchMethodException("Method " + toMethod + " isn't static");
                }
                methodMap.put(fromMethod, toMethod);
            }
        }
        return Proxy.newProxyInstance(classLoader, interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method toMethod = (Method)methodMap.get(method);
                if (toMethod == null) {
                    throw new OperationNotSupportedException("Method " + method + " isn't implemented in " + from.getClass());
                }
                try {
                    return toMethod.invoke(null, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    public static <T> T staticCast(Class<?> from, Class<T> interfase) throws SecurityException, NoSuchMethodException {
        return WeakCastUtils.staticCast(from, interfase, interfase.getClassLoader());
    }

    public static <T> T staticCast(Class<?> from, Class<T> interfase, ClassLoader classLoader) throws SecurityException, NoSuchMethodException {
        return (T)WeakCastUtils.staticCast(from, new Class[]{interfase}, classLoader);
    }

    private WeakCastUtils() {
    }
}

