/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.Validate;

public abstract class LocateableResource {
    public static LocateableResource fromFile(File file) {
        return new FileResource(file);
    }

    public abstract LocateableResource locate(String var1);

    public abstract InputStream openToRead() throws IOException;

    private static class FileResource
    extends LocateableResource {
        private final File file;

        private FileResource(File file) {
            Validate.notNull((Object)file, (String)"File can't be NULL");
            this.file = file;
        }

        @Override
        public LocateableResource locate(String relativePath) {
            String parentPath = this.file.getParentFile().getAbsolutePath();
            if (!parentPath.endsWith(SystemUtils.FILE_SEPARATOR)) {
                parentPath = parentPath + SystemUtils.FILE_SEPARATOR;
            }
            return new FileResource(new File(parentPath + relativePath));
        }

        @Override
        public InputStream openToRead() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return "file://" + this.file;
        }
    }
}

