/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.kaufman.LocateableResource;

public class PropertiesHierarchyUtils {
    public static Properties subset(Properties source, String prefix) {
        Properties props = new Properties();
        for (Object keyObject : source.keySet()) {
            String key = (String)keyObject;
            if (!key.startsWith(prefix + ".")) continue;
            String shortKey = StringUtils.removeStart((String)key, (String)(prefix + "."));
            props.setProperty(shortKey, source.getProperty(key));
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties expandInclusion(LocateableResource resource) throws IOException {
        Properties source = new Properties();
        InputStream in = resource.openToRead();
        try {
            source.load(in);
        }
        finally {
            in.close();
        }
        String includeProperty = source.getProperty("include", null);
        source.remove("include");
        if (StringUtils.isBlank((String)includeProperty)) {
            return source;
        }
        String[] includes = StringUtils.split((String)includeProperty, (char)',');
        Properties result = new Properties();
        for (String include : includes) {
            Properties props = PropertiesHierarchyUtils.expandInclusion(resource.locate(include));
            result.putAll((Map<?, ?>)props);
        }
        result.putAll((Map<?, ?>)source);
        return result;
    }
}

