/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.logging;

import java.util.Arrays;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class InvocationLoggingAdvice {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ProceedingJoinPoint point) throws Throwable {
        String trace = "[" + RandomStringUtils.randomAlphabetic((int)8) + "]";
        Log log = LogFactory.getLog((Class)point.getSignature().getDeclaringType());
        log.info((Object)(trace + " Invoking " + point.getSignature().getName() + "(" + Arrays.toString(point.getArgs()) + ") against " + point.getTarget()));
        long start = System.currentTimeMillis();
        boolean successful = false;
        Object result = null;
        try {
            result = point.proceed();
            successful = true;
            Object object = result;
            return object;
        }
        finally {
            long elapsed = System.currentTimeMillis() - start;
            if (successful) {
                log.info((Object)(trace + " Invocation of " + point.getSignature().getName() + " succeeded and returned " + result + " after " + elapsed + "ms"));
            } else {
                log.error((Object)(trace + " Invocation of " + point.getSignature().getName() + " failed after " + elapsed + "ms"));
            }
        }
    }
}

