/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvocationLoggingDecorator {
    public static <T> T decorate(Class<T> interfaceType, T target) {
        return interfaceType.cast(Proxy.newProxyInstance(InvocationLoggingDecorator.class.getClassLoader(), new Class[]{interfaceType}, new Handler(interfaceType, target)));
    }

    private static class Handler<T>
    implements InvocationHandler {
        private final T target;
        private final Class<T> interfaceType;

        private Handler(Class<T> interfaceType, T target) {
            this.interfaceType = interfaceType;
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.target, args);
            }
            String trace = "[" + RandomStringUtils.randomAlphabetic((int)8) + "]";
            Log log = LogFactory.getLog(this.interfaceType);
            log.info((Object)(trace + " Invoking " + method.getName() + "(" + Arrays.toString(args) + ") against " + this.target));
            long start = System.currentTimeMillis();
            boolean successful = false;
            Object result = null;
            try {
                result = method.invoke(this.target, args);
                successful = true;
                Object object = result;
                return object;
            }
            catch (Throwable e) {
                log.error((Object)("Invocation failed: " + e.getMessage()), e);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            finally {
                long elapsed = System.currentTimeMillis() - start;
                if (successful) {
                    log.info((Object)(trace + " Invocation of " + method.getName() + " succeeded and returned " + result + " after " + elapsed + "ms"));
                } else {
                    log.error((Object)(trace + " Invocation of " + method.getName() + " failed after " + elapsed + "ms"));
                }
            }
        }
    }
}

