/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractRequestAuthorizingFilter
implements Filter {
    private Set<String> pathIgnored = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("/ping")));

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String path = StringUtils.stripToEmpty((String)req.getServletPath()) + StringUtils.stripToEmpty((String)req.getPathInfo());
        if (this.pathIgnored.contains(path)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isRequestAuthorized((HttpServletRequest)request)) {
            ((HttpServletResponse)response).sendError(401, "Request is denied by filter " + this.getClass().getSimpleName());
            return;
        }
        chain.doFilter(request, response);
    }

    protected abstract boolean isRequestAuthorized(HttpServletRequest var1) throws ServletException, IOException;

    public void setPathIgnored(Set<String> paths) {
        this.pathIgnored = Collections.unmodifiableSet(paths);
    }
}

