/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.kaufman.servlet.ServletUtils;

public class DomainRedirectionFilter
implements Filter {
    private static final String HEADER_X_FORWARDED_PROTO = "X-Forwarded-Proto";
    private static final String HEADER_X_FORWARDED_PORT = "X-Forwarded-Port";
    private static final Log LOG = LogFactory.getLog(DomainRedirectionFilter.class);
    private String baseUrl;

    public void destroy() {
    }

    private static String buildUrl(String scheme, String hostName, int port) {
        StringBuilder url = new StringBuilder(scheme.toLowerCase()).append("://").append(hostName);
        if (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443) {
            url.append(":").append(port);
        }
        return url.toString();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (ServletUtils.isBot(request)) {
            chain.doFilter(request, response);
            return;
        }
        ForwardedHttpRequest req = new ForwardedHttpRequest((HttpServletRequest)request);
        if (req.getServerName().equals("localhost") || !req.getMethod().equalsIgnoreCase("get")) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        String requestBase = DomainRedirectionFilter.buildUrl(req.getScheme(), req.getServerName(), req.getServerPort());
        if (requestBase.equalsIgnoreCase(this.baseUrl)) {
            chain.doFilter((ServletRequest)req, response);
            return;
        }
        String requestedUrl = req.getRequestURL().toString();
        String redirectUrl = this.baseUrl + requestedUrl.substring(requestBase.length());
        LOG.info((Object)("Redirecting request from " + requestedUrl + " to new location: " + redirectUrl));
        if (StringUtils.isNotBlank((String)req.getQueryString())) {
            redirectUrl = redirectUrl + "?" + req.getQueryString();
        }
        ((HttpServletResponse)response).sendRedirect(redirectUrl);
    }

    public void init(FilterConfig config) throws ServletException {
        this.baseUrl = config.getInitParameter("baseUrl");
    }

    private static class ForwardedHttpRequest
    extends HttpServletRequestWrapper {
        private final int serverPort;
        private final String scheme;
        private final boolean forwarded;

        protected ForwardedHttpRequest(HttpServletRequest request) {
            super(request);
            boolean changed = false;
            if (request.getHeader(DomainRedirectionFilter.HEADER_X_FORWARDED_PORT) != null) {
                this.serverPort = Integer.parseInt(request.getHeader(DomainRedirectionFilter.HEADER_X_FORWARDED_PORT));
                changed = true;
            } else {
                this.serverPort = super.getServerPort();
            }
            if (request.getHeader(DomainRedirectionFilter.HEADER_X_FORWARDED_PROTO) != null) {
                this.scheme = request.getHeader(DomainRedirectionFilter.HEADER_X_FORWARDED_PROTO);
                changed = true;
            } else {
                this.scheme = super.getScheme();
            }
            this.forwarded = changed;
        }

        public StringBuffer getRequestURL() {
            if (!this.forwarded) {
                return super.getRequestURL();
            }
            String originalBase = DomainRedirectionFilter.buildUrl(super.getScheme(), super.getServerName(), super.getServerPort());
            String url = super.getRequestURL().toString();
            if (url.startsWith(originalBase)) {
                String newBase = DomainRedirectionFilter.buildUrl(this.scheme, super.getServerName(), this.serverPort);
                return new StringBuffer(newBase).append(url.substring(originalBase.length()));
            }
            return super.getRequestURL();
        }

        public String getScheme() {
            return this.scheme;
        }

        public int getServerPort() {
            return this.serverPort;
        }
    }
}

