/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.kaufman.servlet.AbstractRequestAuthorizingFilter;
import org.springframework.util.DigestUtils;

public class DomainWhitelistingFilter
extends AbstractRequestAuthorizingFilter {
    private static final Log LOG = LogFactory.getLog(DomainWhitelistingFilter.class);
    private final Set<String> buildinDomains = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("127.0.0.1", "localhost")));
    private Set<String> whiteDomainHashes = Collections.emptySet();
    private Set<String> whiteDomainNames = Collections.emptySet();

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        String hashes;
        String names = config.getInitParameter("whiteDomainNames");
        if (StringUtils.isNotBlank((String)names)) {
            this.whiteDomainNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(StringUtils.split((String)names, (char)','))));
            LOG.info((Object)("These domains are accepted: " + this.whiteDomainNames));
        }
        if (StringUtils.isNotBlank((String)(hashes = config.getInitParameter("whiteDomainHashes")))) {
            this.whiteDomainHashes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(StringUtils.split((String)hashes, (char)','))));
            LOG.info((Object)("These domain hashes are accepted: " + this.whiteDomainHashes));
        }
        if (this.whiteDomainNames.isEmpty() && this.whiteDomainHashes.isEmpty()) {
            LOG.info((Object)"No domain is configured, only local access to service is allowed");
        }
    }

    @Override
    protected boolean isRequestAuthorized(HttpServletRequest request) throws ServletException, IOException {
        String serverName = request.getServerName();
        if (this.buildinDomains.contains(serverName) || this.whiteDomainNames.contains(serverName)) {
            return true;
        }
        return this.whiteDomainHashes.contains(DigestUtils.md5DigestAsHex((byte[])serverName.getBytes()));
    }
}

