/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class MimeTypesParser {
    private static final String DEFAULT_MIME_TYPES = "/etc/mime.types";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parse(File mimeTypes) throws IOException {
        Properties props = new Properties();
        LineNumberReader in = new LineNumberReader(new FileReader(mimeTypes));
        try {
            String line = in.readLine();
            while (line != null) {
                String[] chunks;
                String ln = StringUtils.trimToNull((String)line);
                if (ln != null && !ln.startsWith("#") && (chunks = StringUtils.split((String)ln, (char)'\t')).length >= 2) {
                    String[] extensions;
                    String mimeType = chunks[0];
                    for (String extension : extensions = StringUtils.split((String)chunks[1], (char)' ')) {
                        props.setProperty(extension, mimeType);
                    }
                }
                line = in.readLine();
            }
            Properties properties = props;
            return properties;
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
    }

    private Properties parse() throws IOException {
        return this.parse(new File(DEFAULT_MIME_TYPES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println("Generating mimetypes from /etc/mime.types");
        if (args.length > 1) {
            throw new IllegalArgumentException("Invalid arguments " + Arrays.toString(args));
        }
        Properties props = new MimeTypesParser().parse();
        if (args.length == 0) {
            System.out.println(props);
            return;
        }
        File out = new File(args[0]);
        out.getParentFile().mkdirs();
        FileWriter o = new FileWriter(out);
        try {
            props.store(o, "Generated at " + new Date());
            o.flush();
        }
        finally {
            IOUtils.closeQuietly((Writer)o);
        }
    }
}

