/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.spring;

import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.FactoryBean;

public class MappedFactoryBean<T>
implements FactoryBean<T> {
    private T defaultValue;
    private final String key;
    private final Map<String, T> map;

    public MappedFactoryBean(Map<String, T> map, String key) {
        Validate.notNull(map, (String)"Map can't be NULL");
        Validate.notNull((Object)key, (String)"Key can't be NULL");
        this.map = map;
        this.key = key;
    }

    public T getObject() {
        T value = this.map.get(this.key);
        if (value != null) {
            return value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        throw new IllegalArgumentException("Key " + this.key + " is not mapped to any value, these are valid keys: " + this.map.keySet());
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }
}

