/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.spring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.kaufman.PropertiesHierarchyUtils;
import org.springframework.beans.factory.FactoryBean;

public class PropertyPopulatingFactoryBean<T>
implements FactoryBean<T> {
    private final T bean;
    private String prefix;
    private final Properties properties;

    public PropertyPopulatingFactoryBean(T bean, Properties properties) {
        Validate.notNull(bean, (String)"Bean can't be NULL");
        Validate.notNull((Object)properties, (String)"Source properties can't be NULL");
        this.bean = bean;
        this.properties = properties;
    }

    public T getObject() throws InvocationTargetException, IllegalAccessException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)this.prefix)) {
            Properties subProps = PropertiesHierarchyUtils.subset(this.properties, this.prefix);
            for (Object key : subProps.keySet()) {
                props.put(key.toString(), subProps.getProperty(key.toString()));
            }
        } else {
            for (Object key : this.properties.keySet()) {
                props.put(key.toString(), this.properties.getProperty(key.toString()));
            }
        }
        BeanUtils.populate(this.bean, props);
        return this.bean;
    }

    public Class<?> getObjectType() {
        return this.bean.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

