/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.spring;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;

public class StringFormattingFactoryBean
implements FactoryBean<String> {
    private static final Log LOG = LogFactory.getLog(StringFormattingFactoryBean.class);
    private final String format;
    private List<? extends Object> parameters;

    public StringFormattingFactoryBean(String format) {
        this.format = format;
    }

    public String getObject() {
        Object[] params = this.parameters == null || this.parameters.isEmpty() ? ArrayUtils.EMPTY_OBJECT_ARRAY : this.parameters.toArray();
        LOG.info((Object)("Merging format=" + this.format + ", params=" + Arrays.toString(params)));
        String result = String.format(this.format, params);
        LOG.info((Object)("Returning " + result));
        return result;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setParameters(List<? extends Object> parameters) {
        this.parameters = parameters;
    }
}

