/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.spring;

import java.util.Properties;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.kaufman.PropertiesHierarchyUtils;
import org.springframework.beans.factory.FactoryBean;

public class SubPropertiesFactoryBean
implements FactoryBean<Properties> {
    private final String prefix;
    private String prefixAppended;
    private final Properties source;
    private String suffixAppended;

    static Properties toProperties(ExtendedProperties ep) {
        Properties props = new Properties();
        for (Object key : ep.keySet()) {
            props.setProperty(key.toString(), ep.getString(key.toString()));
        }
        return props;
    }

    public SubPropertiesFactoryBean(Properties source, String prefix) {
        Validate.notNull((Object)source, (String)"Source properties can't be NULL");
        Validate.notEmpty((String)prefix, (String)"Prefix can not be empty");
        this.source = source;
        this.prefix = prefix;
    }

    public Properties getObject() {
        Properties ep = PropertiesHierarchyUtils.subset(this.source, this.prefix);
        Properties props = new Properties();
        for (Object key : ep.keySet()) {
            String newKey = key.toString();
            if (StringUtils.isNotBlank((String)this.prefixAppended)) {
                newKey = this.prefixAppended + "." + newKey;
            }
            if (StringUtils.isNotBlank((String)this.suffixAppended)) {
                newKey = newKey + "." + this.suffixAppended;
            }
            props.setProperty(newKey, ep.getProperty(key.toString()));
        }
        return props;
    }

    public Class<?> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setPrefixAppended(String prefixAppended) {
        this.prefixAppended = prefixAppended;
    }

    public void setSuffixAppended(String suffixAppended) {
        this.suffixAppended = suffixAppended;
    }
}

