/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.web;

import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.LinkTool;
import org.cyclopsgroup.kaufman.web.WebLinkToolConfig;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WebLinkTool
extends LinkTool {
    private WebLinkToolConfig config;
    private boolean externalResourceActivated;
    private String externalResourceBase;
    private String externalResourcePath;

    public LinkTool absolute(String uri) {
        boolean external = false;
        String path = uri;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        for (Pattern p : this.config.getExternalResourcePatterns()) {
            if (!p.matcher(path).find()) continue;
            external = true;
            this.externalResourcePath = path;
            break;
        }
        if (external) {
            this.externalResourceActivated = true;
            return this;
        }
        return super.absolute(uri);
    }

    public void init(Object obj) {
        super.init(obj);
        ViewContext vc = (ViewContext)obj;
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)vc.getServletContext());
        this.config = (WebLinkToolConfig)context.getBean(WebLinkToolConfig.class);
        this.externalResourceBase = this.config.getExternalResourceUrl();
        if (StringUtils.isBlank((String)this.externalResourceBase)) {
            this.externalResourceBase = vc.getServletContext().getContextPath();
        }
    }

    public String toString() {
        if (!this.externalResourceActivated) {
            return super.toString();
        }
        this.externalResourceActivated = false;
        return this.externalResourceBase + this.externalResourcePath;
    }
}

