/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.wfv;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.kaufman.wfv.FieldValidationResult;
import org.cyclopsgroup.kaufman.wfv.FormValidationResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class FormValidationServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(FormValidationServlet.class);

    private static Object newInstance(String typeName) throws ServletException {
        try {
            return Class.forName(typeName).newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Invalid form bean " + typeName, (Throwable)e);
        }
    }

    private FormValidationResult buildResult(BindingResult from) {
        FormValidationResult result = new FormValidationResult();
        HashMap<String, FieldValidationResult> fieldMap = new HashMap<String, FieldValidationResult>();
        for (FieldError f : from.getFieldErrors()) {
            FieldValidationResult fr = (FieldValidationResult)fieldMap.get(f.getField());
            if (fr == null) {
                fr = new FieldValidationResult();
                fr.setFieldName(f.getField());
                fr.setFailureMessages(new ArrayList<String>());
                fieldMap.put(f.getField(), fr);
            }
            fr.getFailureMessages().add(f.getDefaultMessage());
        }
        if (!from.getGlobalErrors().isEmpty()) {
            FieldValidationResult fr = new FieldValidationResult();
            fr.setFieldName("form");
            fr.setFailureMessages(new ArrayList<String>());
            for (ObjectError e : from.getGlobalErrors()) {
                fr.getFailureMessages().add(e.getDefaultMessage());
            }
            fieldMap.put(fr.getFieldName(), fr);
        }
        result.setFields(new ArrayList<FieldValidationResult>(fieldMap.values()));
        result.setSuccessful(result.getFields().isEmpty());
        return result;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.validateForm(req, resp);
    }

    private void validateForm(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String formBeanType = request.getParameter("formBean");
        if (formBeanType == null) {
            throw new ServletException("formBean must be specified");
        }
        Object formBean = FormValidationServlet.newInstance(formBeanType);
        ServletRequestDataBinder binder = new ServletRequestDataBinder(formBean);
        binder.setValidator((Validator)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean(Validator.class));
        binder.bind((ServletRequest)request);
        LOG.info((Object)("Validating form " + ToStringBuilder.reflectionToString((Object)formBean)));
        binder.validate();
        FormValidationResult result = this.buildResult(binder.getBindingResult());
        LOG.info((Object)("Returning validation result in JSON: " + result));
        response.setContentType("application/json");
        new ObjectMapper().writeValue((Writer)response.getWriter(), (Object)result);
        response.getWriter().flush();
    }
}

