/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.tests;

import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class PackageScanner {
    private PackageScanner() {
    }

    public static void scanPackage(String packageName, ClassVisitor visitor) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        for (Resource resource : resources = resolver.getResources("classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/*.class")) {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            String className = reader.getClassMetadata().getClassName();
            try {
                Class<?> type = Class.forName(className);
                visitor.visitClass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Can't visit class " + className, e);
            }
        }
    }

    public static interface ClassVisitor {
        public void visitClass(Class<?> var1);
    }
}

