/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service.impl;

import java.util.List;
import org.dajlab.bricksetapi.v3.service.IBricksetService;
import org.dajlab.bricksetapi.v3.service.impl.GeneralServiceImpl;
import org.dajlab.bricksetapi.v3.service.impl.MinifigCollectionManagementServiceImpl;
import org.dajlab.bricksetapi.v3.service.impl.SetCollectionManagementServiceImpl;
import org.dajlab.bricksetapi.v3.service.impl.SetsServiceImpl;
import org.dajlab.bricksetapi.v3.vo.AdditionalImages;
import org.dajlab.bricksetapi.v3.vo.ApiKeyUsage;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.GetMinifigCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.Instruction;
import org.dajlab.bricksetapi.v3.vo.MinifigCollection;
import org.dajlab.bricksetapi.v3.vo.Set;
import org.dajlab.bricksetapi.v3.vo.SetCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.SetMinifigCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.SetParameters;
import org.dajlab.bricksetapi.v3.vo.Subtheme;
import org.dajlab.bricksetapi.v3.vo.Theme;
import org.dajlab.bricksetapi.v3.vo.UserNotes;
import org.dajlab.bricksetapi.v3.vo.Year;

public class BricksetServiceImpl
implements IBricksetService {
    private GeneralServiceImpl generalService;
    private SetsServiceImpl setsService;
    private SetCollectionManagementServiceImpl setCollectionService;
    private MinifigCollectionManagementServiceImpl minifigCollectionService;

    public BricksetServiceImpl(String apiKey) {
        this.generalService = new GeneralServiceImpl(apiKey);
        this.setsService = new SetsServiceImpl(apiKey);
        this.setCollectionService = new SetCollectionManagementServiceImpl(apiKey);
        this.minifigCollectionService = new MinifigCollectionManagementServiceImpl(apiKey);
    }

    @Override
    public boolean checkKey() throws BricksetException {
        return this.generalService.checkKey();
    }

    @Override
    public String login(String username, String password) throws BricksetException {
        return this.generalService.login(username, password);
    }

    @Override
    public boolean checkUserHash(String userHash) throws BricksetException {
        return this.generalService.checkUserHash(userHash);
    }

    @Override
    public List<ApiKeyUsage> getKeyUsageStats() throws BricksetException {
        return this.generalService.getKeyUsageStats();
    }

    @Override
    public List<Set> getSets(SetParameters params) throws BricksetException {
        return this.setsService.getSets(params);
    }

    @Override
    public List<Set> getSets(SetParameters params, String userHash) throws BricksetException {
        return this.setsService.getSets(params, userHash);
    }

    @Override
    public List<AdditionalImages> getAdditionalImages(int setId) throws BricksetException {
        return this.setsService.getAdditionalImages(setId);
    }

    @Override
    public List<Instruction> getInstructions(int setId) throws BricksetException {
        return this.setsService.getInstructions(setId);
    }

    @Override
    public List<Theme> getThemes() throws BricksetException {
        return this.setsService.getThemes();
    }

    @Override
    public List<Subtheme> getSubthemes(String theme) throws BricksetException {
        return this.setsService.getSubthemes(theme);
    }

    @Override
    public List<Year> getYears(String theme) throws BricksetException {
        return this.setsService.getYears(theme);
    }

    @Override
    public void setCollection(int setId, SetCollectionParameters params, String userHash) throws BricksetException {
        this.setCollectionService.setCollection(setId, params, userHash);
    }

    @Override
    public List<UserNotes> getUserNotes(String userHash) throws BricksetException {
        return this.setCollectionService.getUserNotes(userHash);
    }

    @Override
    public List<MinifigCollection> getMinifigCollection(GetMinifigCollectionParameters params, String userHash) throws BricksetException {
        return this.minifigCollectionService.getMinifigCollection(params, userHash);
    }

    @Override
    public void setMinifigCollection(String minifigNumber, SetMinifigCollectionParameters params, String userHash) throws BricksetException {
        this.minifigCollectionService.setMinifigCollection(minifigNumber, params, userHash);
    }
}

