/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dajlab.bricksetapi.v3.service.AbstractBricksetService;
import org.dajlab.bricksetapi.v3.vo.ApiKeyUsage;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.MessageEnum;
import org.dajlab.bricksetapi.v3.vo.Method;
import org.dajlab.bricksetapi.v3.vo.Response;

public class GeneralServiceImpl
extends AbstractBricksetService {
    private static final String CHECK_KEY = "/checkKey";
    private static final String LOGIN = "/login";
    private static final String CHECK_USER_HASH = "/checkUserHash";
    private static final String GET_KEY_USAGE_STATS = "/getKeyUsageStats";

    public GeneralServiceImpl(String apiKey) {
        super(apiKey);
    }

    public boolean checkKey() throws BricksetException {
        String uri = CHECK_KEY;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return true;
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return false;
    }

    public String login(String username, String password) throws BricksetException {
        String uri = LOGIN;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("username", username);
            parameters.put("password", password);
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getHash();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return null;
    }

    public boolean checkUserHash(String userHash) throws BricksetException {
        String uri = CHECK_USER_HASH;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri, null, userHash);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return true;
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return false;
    }

    public List<ApiKeyUsage> getKeyUsageStats() throws BricksetException {
        String uri = GET_KEY_USAGE_STATS;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getApiKeyUsage();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<ApiKeyUsage>(0);
    }
}

