/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dajlab.bricksetapi.v3.service.AbstractBricksetService;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.MessageEnum;
import org.dajlab.bricksetapi.v3.vo.Method;
import org.dajlab.bricksetapi.v3.vo.Response;
import org.dajlab.bricksetapi.v3.vo.SetCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.UserMinifigNotes;
import org.dajlab.bricksetapi.v3.vo.UserNotes;

public class SetCollectionManagementServiceImpl
extends AbstractBricksetService {
    private static final String SET_COLLECTION = "/setCollection";
    private static final String GET_USER_NOTES = "/getUserNotes";
    private static final String GET_USER_MINIFIG_NOTES = "/getUserMinifigNotes";

    public SetCollectionManagementServiceImpl(String apiKey) {
        super(apiKey);
    }

    public void setCollection(int setId, SetCollectionParameters params, String userHash) throws BricksetException {
        if (params != null) {
            String uri = SET_COLLECTION;
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String parametersStr = mapper.writeValueAsString((Object)params);
                parameters.put("params", parametersStr);
                parameters.put("SetID", setId + "");
                String output = this.returnJsonResponse(Method.GET, uri, parameters, userHash);
                if (output != null) {
                    Response response = (Response)mapper.readValue(output, Response.class);
                    switch (response.getStatus()) {
                        case SUCCESS: {
                            break;
                        }
                        default: {
                            throw new BricksetException(response.getMessage());
                        }
                    }
                }
            }
            catch (JsonProcessingException e) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
            }
        }
    }

    public List<UserNotes> getUserNotes(String userHash) throws BricksetException {
        String uri = GET_USER_NOTES;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri, null, userHash);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getUserNotes();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<UserNotes>();
    }

    public List<UserMinifigNotes> getUserMinifigNotes(String userHash) throws BricksetException {
        String uri = GET_USER_MINIFIG_NOTES;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri, null, userHash);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getUserMinifigNotes();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<UserMinifigNotes>();
    }
}

