/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.MessageEnum;
import org.dajlab.bricksetapi.v3.vo.Method;

public abstract class AbstractBricksetService {
    private String apiKey;
    private static final String API_BASE_URL = "https://brickset.com/api/v3.asmx";

    protected AbstractBricksetService(String apiKey) {
        this.apiKey = apiKey;
    }

    protected String returnJsonResponse(Method method, String uri) throws BricksetException {
        return this.returnJsonResponse(method, uri, null, null);
    }

    protected String returnJsonResponse(Method method, String uri, Map<String, String> parameters, String userHash) throws BricksetException {
        String baseUrl = API_BASE_URL + uri + "?apiKey=" + this.apiKey;
        baseUrl = baseUrl + "&userHash=";
        if (userHash != null) {
            try {
                String encodedUserhash = URLEncoder.encode(userHash, StandardCharsets.UTF_8.toString());
                baseUrl = baseUrl + encodedUserhash;
            }
            catch (UnsupportedEncodingException e) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
            }
        }
        if (parameters != null) {
            StringBuilder params = new StringBuilder();
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                try {
                    String encodedParam = URLEncoder.encode(param.getValue(), StandardCharsets.UTF_8.toString());
                    params.append("&" + param.getKey() + "=" + encodedParam);
                }
                catch (UnsupportedEncodingException e) {
                    throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
                }
            }
            baseUrl = baseUrl + params;
        }
        return this.callRestService(method, baseUrl);
    }

    private String callRestService(Method method, String url) throws BricksetException {
        try {
            URL fullurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)fullurl.openConnection();
            conn.setRequestMethod(method.name());
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, "Failed : HTTP error code : " + conn.getResponseCode());
            }
            return new BufferedReader(new InputStreamReader(conn.getInputStream())).lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
    }
}

