/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dajlab.bricksetapi.v3.service.AbstractBricksetService;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.GetMinifigCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.MessageEnum;
import org.dajlab.bricksetapi.v3.vo.Method;
import org.dajlab.bricksetapi.v3.vo.MinifigCollection;
import org.dajlab.bricksetapi.v3.vo.Response;
import org.dajlab.bricksetapi.v3.vo.SetMinifigCollectionParameters;
import org.dajlab.bricksetapi.v3.vo.UserMinifigNotes;

public class MinifigCollectionManagementServiceImpl
extends AbstractBricksetService {
    private static final String GET_MINIFIG_COLLECTION = "/getMinifigCollection";
    private static final String SET_MINIFIG_COLLECTION = "/setMinifigCollection";
    private static final String GET_USER_MINIFIG_NOTES = "/getUserMinifigNotes";

    public MinifigCollectionManagementServiceImpl(String apiKey) {
        super(apiKey);
    }

    public List<MinifigCollection> getMinifigCollection(GetMinifigCollectionParameters params, String userHash) throws BricksetException {
        if (params != null) {
            String uri = GET_MINIFIG_COLLECTION;
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String parametersStr = mapper.writeValueAsString((Object)params);
                parameters.put("params", parametersStr);
                String output = this.returnJsonResponse(Method.GET, uri, parameters, userHash);
                if (output != null) {
                    Response response = (Response)mapper.readValue(output, Response.class);
                    switch (response.getStatus()) {
                        case SUCCESS: {
                            return response.getMinifigs();
                        }
                    }
                    throw new BricksetException(response.getMessage());
                }
            }
            catch (JsonProcessingException e) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
            }
        }
        return new ArrayList<MinifigCollection>(0);
    }

    public void setMinifigCollection(String minifigNumber, SetMinifigCollectionParameters params, String userHash) throws BricksetException {
        if (params != null) {
            String uri = SET_MINIFIG_COLLECTION;
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String parametersStr = mapper.writeValueAsString((Object)params);
                parameters.put("params", parametersStr);
                parameters.put("minifigNumber", minifigNumber);
                String output = this.returnJsonResponse(Method.GET, uri, parameters, userHash);
                if (output != null) {
                    Response response = (Response)mapper.readValue(output, Response.class);
                    switch (response.getStatus()) {
                        case SUCCESS: {
                            break;
                        }
                        default: {
                            throw new BricksetException(response.getMessage());
                        }
                    }
                }
            }
            catch (JsonProcessingException e) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
            }
        }
    }

    public List<UserMinifigNotes> getUserMinifigNotes(String userHash) throws BricksetException {
        String uri = GET_USER_MINIFIG_NOTES;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri, null, userHash);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getUserMinifigNotes();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<UserMinifigNotes>();
    }
}

