/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.bricksetapi.v3.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dajlab.bricksetapi.v3.service.AbstractBricksetService;
import org.dajlab.bricksetapi.v3.vo.AdditionalImages;
import org.dajlab.bricksetapi.v3.vo.BricksetException;
import org.dajlab.bricksetapi.v3.vo.Instruction;
import org.dajlab.bricksetapi.v3.vo.MessageEnum;
import org.dajlab.bricksetapi.v3.vo.Method;
import org.dajlab.bricksetapi.v3.vo.Response;
import org.dajlab.bricksetapi.v3.vo.Reviews;
import org.dajlab.bricksetapi.v3.vo.Set;
import org.dajlab.bricksetapi.v3.vo.SetParameters;
import org.dajlab.bricksetapi.v3.vo.Subtheme;
import org.dajlab.bricksetapi.v3.vo.Theme;
import org.dajlab.bricksetapi.v3.vo.Year;

public class SetsServiceImpl
extends AbstractBricksetService {
    private static final String GET_SETS = "/getSets";
    private static final String GET_ADDITIONAL_IMAGES = "/getAdditionalImages";
    private static final String GET_INSTRUCTIONS = "/getInstructions";
    private static final String GET_REVIEWS = "/getReviews";
    private static final String GET_THEMES = "/getThemes";
    private static final String GET_SUBTHEMES = "/getSubthemes";
    private static final String GET_YEARS = "/getYears";

    public SetsServiceImpl(String apiKey) {
        super(apiKey);
    }

    public List<Set> getSets(SetParameters params) throws BricksetException {
        return this.getSets(params, null);
    }

    public List<Set> getSets(SetParameters params, String userHash) throws BricksetException {
        if (params != null) {
            String uri = GET_SETS;
            ObjectMapper mapper = new ObjectMapper();
            HashMap<String, String> parameters = new HashMap<String, String>();
            try {
                String parametersStr = mapper.writeValueAsString((Object)params);
                parameters.put("params", parametersStr);
                String output = this.returnJsonResponse(Method.GET, uri, parameters, userHash);
                if (output != null) {
                    Response response = (Response)mapper.readValue(output, Response.class);
                    switch (response.getStatus()) {
                        case SUCCESS: {
                            return response.getSets();
                        }
                    }
                    throw new BricksetException(response.getMessage());
                }
            }
            catch (JsonProcessingException e) {
                throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
            }
        }
        return new ArrayList<Set>(0);
    }

    public List<AdditionalImages> getAdditionalImages(int setId) throws BricksetException {
        String uri = GET_ADDITIONAL_IMAGES;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("setID", setId + "");
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getAdditionalImages();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<AdditionalImages>(0);
    }

    public List<Instruction> getInstructions(int setId) throws BricksetException {
        String uri = GET_INSTRUCTIONS;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("setID", setId + "");
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getInstructions();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<Instruction>(0);
    }

    public List<Reviews> getReviews(int setId) throws BricksetException {
        String uri = GET_REVIEWS;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("setID", setId + "");
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getReviews();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<Reviews>(0);
    }

    public List<Theme> getThemes() throws BricksetException {
        String uri = GET_THEMES;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String output = this.returnJsonResponse(Method.GET, uri);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getThemes();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<Theme>(0);
    }

    public List<Subtheme> getSubthemes(String theme) throws BricksetException {
        String uri = GET_SUBTHEMES;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("theme", theme);
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getSubthemes();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<Subtheme>(0);
    }

    public List<Year> getYears(String theme) throws BricksetException {
        String uri = GET_YEARS;
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> parameters = new HashMap<String, String>();
        try {
            parameters.put("theme", theme);
            String output = this.returnJsonResponse(Method.GET, uri, parameters, null);
            if (output != null) {
                Response response = (Response)mapper.readValue(output, Response.class);
                switch (response.getStatus()) {
                    case SUCCESS: {
                        return response.getYears();
                    }
                }
                throw new BricksetException(response.getMessage());
            }
        }
        catch (JsonProcessingException e) {
            throw new BricksetException(MessageEnum.TECHNICAL_ERROR, e.getMessage());
        }
        return new ArrayList<Year>(0);
    }
}

