/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.HelloThread;
import org.dajlab.jcontrollab.core.Input;
import org.dajlab.jcontrollab.core.InputPortEnum;
import org.dajlab.jcontrollab.core.Output;
import org.dajlab.jcontrollab.core.OutputPortEnum;
import org.dajlab.jcontrollab.core.exception.SerialException;
import org.dajlab.jcontrollab.core.serial.SerialPortFactory;
import org.dajlab.jcontrollab.core.serial.SerialPortInterface;

public class ControlLabImpl
implements ControlLabInterface {
    private Logger logger = LogManager.getLogger((String)ControlLabImpl.class.getName());
    private String port = null;
    private InputStream is = null;
    private DataInputStream dis = null;
    private OutputStream os = null;
    private int[] sensorValues = new int[8];
    private int[] sensorStatus = new int[8];
    private boolean connected = false;
    private SerialPortInterface serialPort;
    private HelloThread hello;
    private Map<OutputPortEnum, Output> outputsMap;
    private Map<InputPortEnum, Input> inputsMap;

    protected ControlLabImpl(String aPort) {
        this.port = aPort;
        this.outputsMap = new HashMap<OutputPortEnum, Output>(8);
        this.inputsMap = new HashMap<InputPortEnum, Input>(8);
    }

    @Override
    public void connect() {
        try {
            this.logger.debug("Try to connect to port [{}]", (Object)this.port);
            this.serialPort = SerialPortFactory.getNewSerialPort(this.port);
            this.os = this.serialPort.getOutputStream();
            this.is = this.serialPort.getInputStream();
            this.dis = new DataInputStream(this.is);
            this.serialPort.addEventListener(SerialPortFactory.getNewSerialPortListener(this));
            if (this.os != null) {
                this.hello = new HelloThread(this.os);
                this.hello.start();
            }
            this.sendMessage("p\u0000###Do you byte, when I knock?$$$".getBytes());
            Thread.sleep(1000L);
            if (!this.connected) {
                this.os.close();
                this.is.close();
                this.dis.close();
                this.serialPort.close();
                this.hello.disconnect();
                throw new SerialException("Error of connection on port " + this.port);
            }
            for (OutputPortEnum portEnum : OutputPortEnum.values()) {
                Output ouput = new Output(this, portEnum);
                this.outputsMap.put(portEnum, ouput);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while initializing ControlLab on port [{}]", (Object)this.port);
            throw new SerialException(e.getMessage());
        }
        this.logger.info("ControlLab initialized on port [{}]", (Object)this.port);
    }

    @Override
    public void disconnect() {
        this.sendMessage((byte)112);
        try {
            if (this.hello != null) {
                this.hello.disconnect();
            }
            this.os.close();
            this.is.close();
            this.dis.close();
            this.serialPort.close();
        }
        catch (Exception e) {
            throw new SerialException(e.getMessage());
        }
        this.logger.info("[{}] disconnected.", (Object)this.port);
    }

    @Override
    public void readData() {
        byte[] buffer = new byte[19];
        boolean correctData = true;
        try {
            if (this.dis.available() > 19) {
                for (int i = 0; i < 19; ++i) {
                    buffer[i] = this.dis.readByte();
                }
                String datas = ControlLabImpl.byteToHex(buffer);
                this.logger.trace("Received data = {}", (Object)datas);
                if (!this.connected) {
                    for (int i = 0; i < buffer.length; ++i) {
                        if (buffer[i] != 36) continue;
                        this.connected = true;
                    }
                }
                if (buffer[0] != 0 || buffer[1] != 0) {
                    if (this.dis.available() > 1) {
                        this.dis.readByte();
                    }
                    correctData = false;
                }
                int chksum = 0;
                for (int i = 0; i < buffer.length; ++i) {
                    int unsignedbyte = buffer[i] & 0xFF;
                    chksum += unsignedbyte;
                }
                if ((chksum & 0xFF) != 255) {
                    correctData = false;
                }
                if (correctData) {
                    this.sensorValues[0] = this.decodeValue(buffer[14], buffer[15]);
                    this.sensorValues[1] = this.decodeValue(buffer[10], buffer[11]);
                    this.sensorValues[2] = this.decodeValue(buffer[6], buffer[7]);
                    this.sensorValues[3] = this.decodeValue(buffer[2], buffer[3]);
                    this.sensorValues[4] = this.decodeValue(buffer[16], buffer[17]);
                    this.sensorValues[5] = this.decodeValue(buffer[12], buffer[13]);
                    this.sensorValues[6] = this.decodeValue(buffer[8], buffer[9]);
                    this.sensorValues[7] = this.decodeValue(buffer[4], buffer[5]);
                    this.sensorStatus[0] = (byte)(buffer[15] & 0x3F);
                    this.sensorStatus[1] = (byte)(buffer[11] & 0x3F);
                    this.sensorStatus[2] = (byte)(buffer[7] & 0x3F);
                    this.sensorStatus[3] = (byte)(buffer[3] & 0x3F);
                    this.sensorStatus[4] = (byte)(buffer[17] & 0x3F);
                    this.sensorStatus[5] = (byte)(buffer[13] & 0x3F);
                    this.sensorStatus[6] = (byte)(buffer[9] & 0x3F);
                    this.sensorStatus[7] = (byte)(buffer[5] & 0x3F);
                    this.fireValuesChanged();
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error while reading the data : {}", (Object)e.getMessage());
        }
    }

    private int decodeValue(byte b1, byte b2) {
        int highbits = (b1 & 0xFF) << 2;
        int lowbits = (b2 & 0xFF) >> 6;
        return highbits + lowbits;
    }

    @Override
    public int[] getSensorValues() {
        return this.sensorValues;
    }

    private void fireValuesChanged() {
        for (Input input : this.inputsMap.values()) {
            input.setValue((short)this.sensorValues[input.getPort().getPort() - 1]);
            input.setStatus(this.sensorStatus[input.getPort().getPort() - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(byte[] message) {
        try {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                this.os.write(message);
            }
        }
        catch (IOException e) {
            this.logger.error("Error while writting data : {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(byte message) {
        try {
            OutputStream outputStream = this.os;
            synchronized (outputStream) {
                this.os.write(message);
            }
        }
        catch (IOException e) {
            this.logger.error("Error while writting data : {}", (Object)e.getMessage());
        }
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public static final String byteToHex(byte[] data) {
        StringBuilder mess = new StringBuilder();
        for (int i = 0; i < data.length - 1; ++i) {
            byte b = data[i];
            mess.append(String.format("%02X ", b));
        }
        mess.append(String.format("%02X", data[data.length - 1]));
        return mess.toString();
    }

    @Override
    public Output getOuput(OutputPortEnum outputPort) {
        return this.outputsMap.get((Object)outputPort);
    }

    @Override
    public <S extends Input> S getInput(Class<S> clazz, InputPortEnum inputPort) {
        Input ret = null;
        Input input = this.inputsMap.get((Object)inputPort);
        try {
            if (input == null) {
                ret = (Input)clazz.getConstructor(ControlLabInterface.class, InputPortEnum.class).newInstance(new Object[]{this, inputPort});
                this.inputsMap.put(inputPort, ret);
            } else if (clazz.equals(input.getClass())) {
                ret = input;
            } else {
                ret = (Input)clazz.getConstructor(ControlLabInterface.class, InputPortEnum.class).newInstance(new Object[]{this, inputPort});
                this.inputsMap.put(inputPort, ret);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (S)ret;
    }
}

