/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dajlab.jcontrollab.core.ControlLabImpl;
import org.dajlab.jcontrollab.core.ControlLabInterface;
import org.dajlab.jcontrollab.core.exception.SerialException;
import org.dajlab.jcontrollab.core.serial.SerialPortFactory;

public class ControlLabManager {
    private List<ControlLabInterface> controlLabs;
    private Logger logger = LogManager.getLogger(ControlLabManager.class);

    public ControlLabManager() {
        this.controlLabs = new ArrayList<ControlLabInterface>();
    }

    public void connect() {
        List<String> ports = SerialPortFactory.getAvailablePorts();
        if (ports != null) {
            for (String port : ports) {
                ControlLabImpl controlLab = new ControlLabImpl(port);
                try {
                    controlLab.connect();
                    this.controlLabs.add(controlLab);
                }
                catch (SerialException serialException) {}
            }
            this.logger.debug("Number of Control Lab connected : [{}]", (Object)this.controlLabs.size());
        }
    }

    public void disconnect() {
        for (ControlLabInterface controlLabInterface : this.controlLabs) {
            controlLabInterface.disconnect();
        }
    }

    public final List<ControlLabInterface> getControlLabs() {
        return this.controlLabs;
    }
}

