/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.core;

import java.util.HashMap;
import java.util.Map;
import org.dajlab.jcontrollab.core.CLIProtocol;
import org.dajlab.jcontrollab.core.ControlLabImpl;
import org.dajlab.jcontrollab.core.Output;
import org.dajlab.jcontrollab.core.OutputInterface;

public class OutputsGroup
implements OutputInterface {
    private Map<String, Object[]> controlLabsMap = new HashMap<String, Object[]>(4);

    public void addOutput(Output output) {
        String portController = output.getControlLab().getPort();
        if (!this.controlLabsMap.containsKey(portController)) {
            Object[] objs = new Object[2];
            objs[0] = output.getControlLab();
            StringBuffer buff = new StringBuffer(8);
            buff.append((Object)output.getPort());
            objs[1] = buff;
            this.controlLabsMap.put(portController, objs);
        } else {
            Object[] objs = this.controlLabsMap.get(portController);
            StringBuffer buff = (StringBuffer)objs[1];
            buff.append((Object)output.getPort());
        }
    }

    @Override
    public void backwardAndRun() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 148));
            clc.sendMessage(CLIProtocol.encodeMode(ports, 145));
        }
    }

    @Override
    public void backward() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 148));
        }
    }

    @Override
    public void forward() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 147));
        }
    }

    @Override
    public void forwardAndRun() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 147));
            clc.sendMessage(CLIProtocol.encodeMode(ports, 145));
        }
    }

    @Override
    public void reverseDirection() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 149));
        }
    }

    @Override
    public void run() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 145));
        }
    }

    @Override
    public void runFor(int time) {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeModeDuration(ports, time));
        }
    }

    @Override
    public void setCyclicMode(int on, int off) {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeCycle(ports, on, off));
        }
    }

    @Override
    public void setPower(int power) {
        int aPower = Math.abs(power) % 9;
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeModePower(ports, (short)aPower));
        }
    }

    @Override
    public void startCycle() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 129));
        }
    }

    @Override
    public void stop() {
        for (Object[] objs : this.controlLabsMap.values()) {
            ControlLabImpl clc = (ControlLabImpl)objs[0];
            char[] ports = ((StringBuffer)objs[1]).toString().toCharArray();
            clc.sendMessage(CLIProtocol.encodeMode(ports, 144));
        }
    }
}

