/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.jcontrollab.gui.view;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.dajlab.core.CommandListener;
import org.dajlab.gui.AbstractDajlabTab;
import org.dajlab.jcontrollab.core.OutputPortEnum;
import org.dajlab.jcontrollab.gui.model.ConsoleModel;
import org.dajlab.jcontrollab.gui.model.OutputModel;
import org.dajlab.jcontrollab.gui.view.OutputPane;
import org.dajlab.jcontrollab.gui.view.TitlePane;

public class ControlLabTab
extends AbstractDajlabTab {
    private ConsoleModel model;

    public ControlLabTab(ConsoleModel consoleModel, CommandListener listener) {
        this.model = consoleModel;
        this.textProperty().bind((ObservableValue)this.model.titleProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.model.portProperty());
        this.setTooltip(tooltip);
        this.enableRenaming("/jcontrollab32.png");
        this.setClosable(false);
        GridPane grid = new GridPane();
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(10.0);
        grid.setPadding(new Insets(10.0));
        grid.add((Node)new TitlePane(), 0, 0);
        int i = 1;
        for (OutputPortEnum outEnum : OutputPortEnum.values()) {
            OutputModel outputModel = this.model.getOutputModelsMap().get((Object)outEnum);
            OutputPane pane = new OutputPane(outputModel);
            outputModel.consoleNumberProperty().bind((ObservableValue)this.model.numberProperty());
            pane.addCommandListeners(listener);
            grid.add((Node)pane, 0, i);
            ++i;
        }
        this.setContent((Node)grid);
    }

    public void updateTitle(String title) {
        this.model.setTitle(title);
    }
}

