/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.mondialrelayapi;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.commons.codec.digest.DigestUtils;
import org.dajlab.mondialrelayapi.IMondialRelayService;
import org.dajlab.mondialrelayapi.soap.RetWSI2SubTracingColisDetaille;
import org.dajlab.mondialrelayapi.soap.RetWSI2TracingColisDetaille;
import org.dajlab.mondialrelayapi.soap.WebServicesSoap;
import org.dajlab.mondialrelayapi.vo.MREvenementSuivi;
import org.dajlab.mondialrelayapi.vo.MRException;
import org.dajlab.mondialrelayapi.vo.MRStatut;
import org.dajlab.mondialrelayapi.vo.MRSuiviColis;

public class MondialRelayServiceImpl
implements IMondialRelayService {
    private static final String URL = "https://api.mondialrelay.com/Web_Services.asmx?WSDL";
    private WebServicesSoap mrService;
    private String enseigne;
    private String cle;
    private String langue = "FR";

    public MondialRelayServiceImpl(String enseigne, String cle) throws MRException {
        this.enseigne = enseigne;
        this.cle = cle;
        try {
            URL url = new URL(URL);
            QName qname = new QName("http://www.mondialrelay.fr/webservice/", "Web_Services");
            Service service = Service.create((URL)url, (QName)qname);
            this.mrService = (WebServicesSoap)service.getPort(WebServicesSoap.class);
            String endpointURL = "https://api.mondialrelay.com/Web_Services.asmx";
            BindingProvider bp = (BindingProvider)this.mrService;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointURL);
        }
        catch (Exception e) {
            throw new MRException(e.getMessage());
        }
    }

    @Override
    public MRSuiviColis getSuivi(String numeroSuivi) throws MRException {
        return this.getSuivi(numeroSuivi, this.langue);
    }

    @Override
    public MRSuiviColis getSuivi(String numeroSuivi, String langue) throws MRException {
        MRSuiviColis suivi = null;
        try {
            MRStatut stat;
            RetWSI2TracingColisDetaille retour = this.mrService.wsi2TracingColisDetaille(this.enseigne, numeroSuivi, langue, this.genererCleSecurite(this.enseigne, numeroSuivi, langue));
            if (retour != null && (stat = MRStatut.fromCode(retour.getSTAT())) != null) {
                switch (stat) {
                    case STAT0: 
                    case STAT80: 
                    case STAT81: 
                    case STAT82: 
                    case STAT83: {
                        suivi = this.creerSuivi(retour, stat);
                        break;
                    }
                    default: {
                        suivi = new MRSuiviColis();
                        suivi.setStatut(stat);
                    }
                }
                suivi.setNumeroSuivi(numeroSuivi);
            }
        }
        catch (Exception e) {
            throw new MRException(e.getMessage());
        }
        return suivi;
    }

    private MRSuiviColis creerSuivi(RetWSI2TracingColisDetaille retour, MRStatut stat) {
        MRSuiviColis suivi = new MRSuiviColis();
        suivi.setStatut(stat);
        suivi.setLibelle01(retour.getLibelle01());
        suivi.setLibelle02(retour.getLibelle02());
        suivi.setLibelleRelais(retour.getRelaisLibelle());
        suivi.setNumeroRelais(retour.getRelaisNum());
        if (retour.getTracing() != null && retour.getTracing().getRetWSI2SubTracingColisDetaille() != null) {
            for (RetWSI2SubTracingColisDetaille subTracing : retour.getTracing().getRetWSI2SubTracingColisDetaille()) {
                if (subTracing.getDate() == null || subTracing.getDate().length() <= 0) continue;
                MREvenementSuivi evenement = new MREvenementSuivi(subTracing.getDate(), subTracing.getHeure());
                evenement.setEmplacement(subTracing.getEmplacement());
                evenement.setLibelle(subTracing.getLibelle());
                evenement.setNumeroRelais(subTracing.getRelaisNum());
                evenement.setPaysRelais(subTracing.getRelaisPays());
                suivi.getEvenements().add(evenement);
            }
        }
        return suivi;
    }

    private String genererCleSecurite(String ... parametres) {
        StringBuilder sb = new StringBuilder();
        for (String parametre : parametres) {
            sb.append(parametre);
        }
        sb.append(this.cle);
        String cleSecurite = DigestUtils.md5Hex((String)sb.toString()).toUpperCase();
        return cleSecurite;
    }
}

