/*
 * Decompiled with CFR 0.152.
 */
package org.dajlab.rebrickableapi.v3.service;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import org.dajlab.rebrickableapi.v3.enumeration.Method;
import org.dajlab.rebrickableapi.v3.service.lego.IService;
import org.dajlab.rebrickableapi.v3.vo.RebrickableException;

public abstract class AbstractRebrickableService
implements IService {
    private String key;
    private static final String API_BASE_URL = "https://rebrickable.com/api/v3";

    protected AbstractRebrickableService(String privateKey) {
        this.key = privateKey;
    }

    protected String returnJsonResponse(Method method, String uri) throws RebrickableException {
        return this.returnJsonResponse(method, uri, null);
    }

    protected String returnJsonResponse(Method method, String uri, Map<String, String> parameters) throws RebrickableException {
        String baseUrl = API_BASE_URL + uri + "?key=" + this.key;
        if (parameters != null) {
            StringBuilder params = new StringBuilder();
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                params.append(param.getKey() + "=" + param.getValue());
            }
            baseUrl = baseUrl + "&" + params;
        }
        return this.callRestService(method, baseUrl);
    }

    private String callRestService(Method method, String url) throws RebrickableException {
        try {
            URL fullurl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)fullurl.openConnection();
            conn.setRequestMethod(method.name());
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RebrickableException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            return new BufferedReader(new InputStreamReader(conn.getInputStream())).lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RebrickableException(e.getMessage());
        }
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }
}

