/*
 * Decompiled with CFR 0.152.
 */
package org.dalesbred.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.dalesbred.Database;
import org.dalesbred.connection.ConnectionProvider;
import org.dalesbred.connection.DriverManagerConnectionProvider;
import org.dalesbred.dialect.Dialect;
import org.dalesbred.transaction.TransactionCallback;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

public final class TestDatabaseProvider {
    private TestDatabaseProvider() {
    }

    @NotNull
    public static Database databaseForProperties(@NotNull String propertiesPath) {
        return new Database(TestDatabaseProvider.createConnectionProvider(propertiesPath));
    }

    @NotNull
    public static Database databaseForProperties(@NotNull String propertiesPath, @NotNull Dialect dialect) {
        return new Database(TestDatabaseProvider.createConnectionProvider(propertiesPath), dialect);
    }

    @NotNull
    private static ConnectionProvider createConnectionProvider(@NotNull String propertiesPath) {
        Properties props = TestDatabaseProvider.loadConnectionProperties(propertiesPath);
        String url = props.getProperty("jdbc.url");
        if (url == null) {
            throw new RuntimeException("Could not find 'jdbc.url' in '" + propertiesPath + "'.");
        }
        String login = props.getProperty("jdbc.login");
        String password = props.getProperty("jdbc.password");
        return new DriverManagerConnectionProvider(url, login, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Properties loadConnectionProperties(@NotNull String propertiesName) {
        Properties properties;
        InputStream in = TransactionCallback.class.getClassLoader().getResourceAsStream(propertiesName);
        Assume.assumeTrue((String)("Could not find database configuration file '" + propertiesName + "'."), (in != null ? 1 : 0) != 0);
        assert (in != null);
        try {
            Properties properties2 = new Properties();
            properties2.load(in);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return properties;
    }
}

