/*
 * Decompiled with CFR 0.152.
 */
package org.dalesbred.junit;

import java.util.Objects;
import javax.inject.Provider;
import org.dalesbred.Database;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class TransactionalTests
implements TestRule {
    @NotNull
    private final Provider<Database> db;
    @NotNull
    private final RollbackPolicy rollbackPolicy;

    public TransactionalTests(@NotNull Database db) {
        this(db, RollbackPolicy.ROLLBACK_ON_FAILURE);
    }

    public TransactionalTests(@NotNull Database db, @NotNull RollbackPolicy rollbackPolicy) {
        this((Provider<Database>)((Provider)() -> db), rollbackPolicy);
    }

    public TransactionalTests(@NotNull Provider<Database> db) {
        this(db, RollbackPolicy.ROLLBACK_ON_FAILURE);
    }

    public TransactionalTests(@NotNull Provider<Database> db, @NotNull RollbackPolicy rollbackPolicy) {
        this.db = Objects.requireNonNull(db);
        this.rollbackPolicy = Objects.requireNonNull(rollbackPolicy);
    }

    @NotNull
    public Statement apply(final @NotNull Statement base, @NotNull Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable throwable = (Throwable)((Database)TransactionalTests.this.db.get()).withTransaction(tx -> {
                    try {
                        base.evaluate();
                        if (TransactionalTests.this.rollbackPolicy == RollbackPolicy.ROLLBACK_ALWAYS) {
                            tx.setRollbackOnly();
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        if (TransactionalTests.this.rollbackPolicy != RollbackPolicy.ROLLBACK_NEVER) {
                            tx.setRollbackOnly();
                        }
                        return e;
                    }
                });
                if (throwable != null) {
                    throw throwable;
                }
            }
        };
    }

    public static enum RollbackPolicy {
        ROLLBACK_ON_FAILURE,
        ROLLBACK_NEVER,
        ROLLBACK_ALWAYS;

    }
}

