
package org.damap.base.rest.madmp.dto;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * The DMP Contact Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "contact_id",
    "mbox",
    "name"
})
@Generated("jsonschema2pojo")
public class Contact {

    /**
     * The Contact ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact_id")
    private ContactId contactId;
    /**
     * The Mailbox Schema
     * <p>
     * Contact Person's E-mail address
     * (Required)
     * 
     */
    @JsonProperty("mbox")
    @JsonPropertyDescription("Contact Person's E-mail address")
    private String mbox;
    /**
     * The Name Schema
     * <p>
     * Name of the contact person
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Name of the contact person")
    private String name;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Contact ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact_id")
    public ContactId getContactId() {
        return contactId;
    }

    /**
     * The Contact ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact_id")
    public void setContactId(ContactId contactId) {
        this.contactId = contactId;
    }

    /**
     * The Mailbox Schema
     * <p>
     * Contact Person's E-mail address
     * (Required)
     * 
     */
    @JsonProperty("mbox")
    public String getMbox() {
        return mbox;
    }

    /**
     * The Mailbox Schema
     * <p>
     * Contact Person's E-mail address
     * (Required)
     * 
     */
    @JsonProperty("mbox")
    public void setMbox(String mbox) {
        this.mbox = mbox;
    }

    /**
     * The Name Schema
     * <p>
     * Name of the contact person
     * (Required)
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * The Name Schema
     * <p>
     * Name of the contact person
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Contact.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contactId");
        sb.append('=');
        sb.append(((this.contactId == null)?"<null>":this.contactId));
        sb.append(',');
        sb.append("mbox");
        sb.append('=');
        sb.append(((this.mbox == null)?"<null>":this.mbox));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.contactId == null)? 0 :this.contactId.hashCode()));
        result = ((result* 31)+((this.mbox == null)? 0 :this.mbox.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Contact) == false) {
            return false;
        }
        Contact rhs = ((Contact) other);
        return (((((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.contactId == rhs.contactId)||((this.contactId!= null)&&this.contactId.equals(rhs.contactId))))&&((this.mbox == rhs.mbox)||((this.mbox!= null)&&this.mbox.equals(rhs.mbox))));
    }

}
