
package org.damap.base.rest.madmp.dto;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * The DMP Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "contact",
    "contributor",
    "cost",
    "created",
    "dataset",
    "description",
    "dmp_id",
    "ethical_issues_description",
    "ethical_issues_exist",
    "ethical_issues_report",
    "language",
    "modified",
    "project",
    "title"
})
@Generated("jsonschema2pojo")
public class Dmp {

    /**
     * The DMP Contact Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact")
    private Contact contact;
    /**
     * The Contributor Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("contributor")
    private List<Contributor> contributor = new ArrayList<Contributor>();
    /**
     * The Cost Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("cost")
    private List<Cost> cost = new ArrayList<Cost>();
    /**
     * The DMP Creation Schema
     * <p>
     * Date and time of the first version of a DMP. Must not be changed in subsequent DMPs. Encoded using the relevant ISO 8601 Date and Time compliant string
     * (Required)
     * 
     */
    @JsonProperty("created")
    @JsonPropertyDescription("Date and time of the first version of a DMP. Must not be changed in subsequent DMPs. Encoded using the relevant ISO 8601 Date and Time compliant string")
    private Date created;
    /**
     * The Dataset Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataset")
    private List<Dataset> dataset = new ArrayList<Dataset>();
    /**
     * The DMP Description Schema
     * <p>
     * To provide any free-form text information on a DMP
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("To provide any free-form text information on a DMP")
    private String description;
    /**
     * The DMP Identifier Schema
     * <p>
     * Identifier for the DMP itself
     * (Required)
     * 
     */
    @JsonProperty("dmp_id")
    @JsonPropertyDescription("Identifier for the DMP itself")
    private DmpId dmpId;
    /**
     * The DMP Ethical Issues Description Schema
     * <p>
     * To describe ethical issues directly in a DMP
     * 
     */
    @JsonProperty("ethical_issues_description")
    @JsonPropertyDescription("To describe ethical issues directly in a DMP")
    private String ethicalIssuesDescription;
    /**
     * The DMP Ethical Issues Exist Schema
     * <p>
     * To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("ethical_issues_exist")
    @JsonPropertyDescription("To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown")
    private Dmp.EthicalIssuesExist ethicalIssuesExist;
    /**
     * The DMP Ethical Issues Report Schema
     * <p>
     * To indicate where a protocol from a meeting with an ethical commitee can be found
     * 
     */
    @JsonProperty("ethical_issues_report")
    @JsonPropertyDescription("To indicate where a protocol from a meeting with an ethical commitee can be found")
    private URI ethicalIssuesReport;
    /**
     * The DMP Language Schema
     * <p>
     * Language of the DMP expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Language of the DMP expressed using ISO 639-3.")
    private Dmp.Language language;
    /**
     * The DMP Modification Schema
     * <p>
     * Must be set each time DMP is modified. Indicates DMP version. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("modified")
    @JsonPropertyDescription("Must be set each time DMP is modified. Indicates DMP version. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private Date modified;
    /**
     * The DMP Project Schema
     * <p>
     * Project related to a DMP
     * 
     */
    @JsonProperty("project")
    @JsonPropertyDescription("Project related to a DMP")
    private List<Project> project = new ArrayList<Project>();
    /**
     * The DMP Title Schema
     * <p>
     * Title of a DMP
     * (Required)
     * 
     */
    @JsonProperty("title")
    @JsonPropertyDescription("Title of a DMP")
    private String title;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The DMP Contact Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact")
    public Contact getContact() {
        return contact;
    }

    /**
     * The DMP Contact Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("contact")
    public void setContact(Contact contact) {
        this.contact = contact;
    }

    /**
     * The Contributor Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("contributor")
    public List<Contributor> getContributor() {
        return contributor;
    }

    /**
     * The Contributor Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("contributor")
    public void setContributor(List<Contributor> contributor) {
        this.contributor = contributor;
    }

    /**
     * The Cost Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("cost")
    public List<Cost> getCost() {
        return cost;
    }

    /**
     * The Cost Schema
     * <p>
     * 
     * 
     */
    @JsonProperty("cost")
    public void setCost(List<Cost> cost) {
        this.cost = cost;
    }

    /**
     * The DMP Creation Schema
     * <p>
     * Date and time of the first version of a DMP. Must not be changed in subsequent DMPs. Encoded using the relevant ISO 8601 Date and Time compliant string
     * (Required)
     * 
     */
    @JsonProperty("created")
    public Date getCreated() {
        return created;
    }

    /**
     * The DMP Creation Schema
     * <p>
     * Date and time of the first version of a DMP. Must not be changed in subsequent DMPs. Encoded using the relevant ISO 8601 Date and Time compliant string
     * (Required)
     * 
     */
    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    /**
     * The Dataset Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataset")
    public List<Dataset> getDataset() {
        return dataset;
    }

    /**
     * The Dataset Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataset")
    public void setDataset(List<Dataset> dataset) {
        this.dataset = dataset;
    }

    /**
     * The DMP Description Schema
     * <p>
     * To provide any free-form text information on a DMP
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The DMP Description Schema
     * <p>
     * To provide any free-form text information on a DMP
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The DMP Identifier Schema
     * <p>
     * Identifier for the DMP itself
     * (Required)
     * 
     */
    @JsonProperty("dmp_id")
    public DmpId getDmpId() {
        return dmpId;
    }

    /**
     * The DMP Identifier Schema
     * <p>
     * Identifier for the DMP itself
     * (Required)
     * 
     */
    @JsonProperty("dmp_id")
    public void setDmpId(DmpId dmpId) {
        this.dmpId = dmpId;
    }

    /**
     * The DMP Ethical Issues Description Schema
     * <p>
     * To describe ethical issues directly in a DMP
     * 
     */
    @JsonProperty("ethical_issues_description")
    public String getEthicalIssuesDescription() {
        return ethicalIssuesDescription;
    }

    /**
     * The DMP Ethical Issues Description Schema
     * <p>
     * To describe ethical issues directly in a DMP
     * 
     */
    @JsonProperty("ethical_issues_description")
    public void setEthicalIssuesDescription(String ethicalIssuesDescription) {
        this.ethicalIssuesDescription = ethicalIssuesDescription;
    }

    /**
     * The DMP Ethical Issues Exist Schema
     * <p>
     * To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("ethical_issues_exist")
    public Dmp.EthicalIssuesExist getEthicalIssuesExist() {
        return ethicalIssuesExist;
    }

    /**
     * The DMP Ethical Issues Exist Schema
     * <p>
     * To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown
     * (Required)
     * 
     */
    @JsonProperty("ethical_issues_exist")
    public void setEthicalIssuesExist(Dmp.EthicalIssuesExist ethicalIssuesExist) {
        this.ethicalIssuesExist = ethicalIssuesExist;
    }

    /**
     * The DMP Ethical Issues Report Schema
     * <p>
     * To indicate where a protocol from a meeting with an ethical commitee can be found
     * 
     */
    @JsonProperty("ethical_issues_report")
    public URI getEthicalIssuesReport() {
        return ethicalIssuesReport;
    }

    /**
     * The DMP Ethical Issues Report Schema
     * <p>
     * To indicate where a protocol from a meeting with an ethical commitee can be found
     * 
     */
    @JsonProperty("ethical_issues_report")
    public void setEthicalIssuesReport(URI ethicalIssuesReport) {
        this.ethicalIssuesReport = ethicalIssuesReport;
    }

    /**
     * The DMP Language Schema
     * <p>
     * Language of the DMP expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    public Dmp.Language getLanguage() {
        return language;
    }

    /**
     * The DMP Language Schema
     * <p>
     * Language of the DMP expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    public void setLanguage(Dmp.Language language) {
        this.language = language;
    }

    /**
     * The DMP Modification Schema
     * <p>
     * Must be set each time DMP is modified. Indicates DMP version. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("modified")
    public Date getModified() {
        return modified;
    }

    /**
     * The DMP Modification Schema
     * <p>
     * Must be set each time DMP is modified. Indicates DMP version. Encoded using the relevant ISO 8601 Date and Time compliant string.
     * (Required)
     * 
     */
    @JsonProperty("modified")
    public void setModified(Date modified) {
        this.modified = modified;
    }

    /**
     * The DMP Project Schema
     * <p>
     * Project related to a DMP
     * 
     */
    @JsonProperty("project")
    public List<Project> getProject() {
        return project;
    }

    /**
     * The DMP Project Schema
     * <p>
     * Project related to a DMP
     * 
     */
    @JsonProperty("project")
    public void setProject(List<Project> project) {
        this.project = project;
    }

    /**
     * The DMP Title Schema
     * <p>
     * Title of a DMP
     * (Required)
     * 
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * The DMP Title Schema
     * <p>
     * Title of a DMP
     * (Required)
     * 
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dmp.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("contact");
        sb.append('=');
        sb.append(((this.contact == null)?"<null>":this.contact));
        sb.append(',');
        sb.append("contributor");
        sb.append('=');
        sb.append(((this.contributor == null)?"<null>":this.contributor));
        sb.append(',');
        sb.append("cost");
        sb.append('=');
        sb.append(((this.cost == null)?"<null>":this.cost));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataset");
        sb.append('=');
        sb.append(((this.dataset == null)?"<null>":this.dataset));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dmpId");
        sb.append('=');
        sb.append(((this.dmpId == null)?"<null>":this.dmpId));
        sb.append(',');
        sb.append("ethicalIssuesDescription");
        sb.append('=');
        sb.append(((this.ethicalIssuesDescription == null)?"<null>":this.ethicalIssuesDescription));
        sb.append(',');
        sb.append("ethicalIssuesExist");
        sb.append('=');
        sb.append(((this.ethicalIssuesExist == null)?"<null>":this.ethicalIssuesExist));
        sb.append(',');
        sb.append("ethicalIssuesReport");
        sb.append('=');
        sb.append(((this.ethicalIssuesReport == null)?"<null>":this.ethicalIssuesReport));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("modified");
        sb.append('=');
        sb.append(((this.modified == null)?"<null>":this.modified));
        sb.append(',');
        sb.append("project");
        sb.append('=');
        sb.append(((this.project == null)?"<null>":this.project));
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(((this.title == null)?"<null>":this.title));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.cost == null)? 0 :this.cost.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.ethicalIssuesExist == null)? 0 :this.ethicalIssuesExist.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.project == null)? 0 :this.project.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.title == null)? 0 :this.title.hashCode()));
        result = ((result* 31)+((this.contributor == null)? 0 :this.contributor.hashCode()));
        result = ((result* 31)+((this.dmpId == null)? 0 :this.dmpId.hashCode()));
        result = ((result* 31)+((this.contact == null)? 0 :this.contact.hashCode()));
        result = ((result* 31)+((this.modified == null)? 0 :this.modified.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataset == null)? 0 :this.dataset.hashCode()));
        result = ((result* 31)+((this.ethicalIssuesReport == null)? 0 :this.ethicalIssuesReport.hashCode()));
        result = ((result* 31)+((this.ethicalIssuesDescription == null)? 0 :this.ethicalIssuesDescription.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Dmp) == false) {
            return false;
        }
        Dmp rhs = ((Dmp) other);
        return ((((((((((((((((this.cost == rhs.cost)||((this.cost!= null)&&this.cost.equals(rhs.cost)))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.ethicalIssuesExist == rhs.ethicalIssuesExist)||((this.ethicalIssuesExist!= null)&&this.ethicalIssuesExist.equals(rhs.ethicalIssuesExist))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.project == rhs.project)||((this.project!= null)&&this.project.equals(rhs.project))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.title == rhs.title)||((this.title!= null)&&this.title.equals(rhs.title))))&&((this.contributor == rhs.contributor)||((this.contributor!= null)&&this.contributor.equals(rhs.contributor))))&&((this.dmpId == rhs.dmpId)||((this.dmpId!= null)&&this.dmpId.equals(rhs.dmpId))))&&((this.contact == rhs.contact)||((this.contact!= null)&&this.contact.equals(rhs.contact))))&&((this.modified == rhs.modified)||((this.modified!= null)&&this.modified.equals(rhs.modified))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataset == rhs.dataset)||((this.dataset!= null)&&this.dataset.equals(rhs.dataset))))&&((this.ethicalIssuesReport == rhs.ethicalIssuesReport)||((this.ethicalIssuesReport!= null)&&this.ethicalIssuesReport.equals(rhs.ethicalIssuesReport))))&&((this.ethicalIssuesDescription == rhs.ethicalIssuesDescription)||((this.ethicalIssuesDescription!= null)&&this.ethicalIssuesDescription.equals(rhs.ethicalIssuesDescription))));
    }


    /**
     * The DMP Ethical Issues Exist Schema
     * <p>
     * To indicate whether there are ethical issues related to data that this DMP describes. Allowed values: yes, no, unknown
     * 
     */
    @Generated("jsonschema2pojo")
    public enum EthicalIssuesExist {

        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");
        private final String value;
        private final static Map<String, Dmp.EthicalIssuesExist> CONSTANTS = new HashMap<String, Dmp.EthicalIssuesExist>();

        static {
            for (Dmp.EthicalIssuesExist c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EthicalIssuesExist(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dmp.EthicalIssuesExist fromValue(String value) {
            Dmp.EthicalIssuesExist constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * The DMP Language Schema
     * <p>
     * Language of the DMP expressed using ISO 639-3.
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Language {

        AAR("aar"),
        ABK("abk"),
        AFR("afr"),
        AKA("aka"),
        AMH("amh"),
        ARA("ara"),
        ARG("arg"),
        ASM("asm"),
        AVA("ava"),
        AVE("ave"),
        AYM("aym"),
        AZE("aze"),
        BAK("bak"),
        BAM("bam"),
        BEL("bel"),
        BEN("ben"),
        BIH("bih"),
        BIS("bis"),
        BOD("bod"),
        BOS("bos"),
        BRE("bre"),
        BUL("bul"),
        CAT("cat"),
        CES("ces"),
        CHA("cha"),
        CHE("che"),
        CHU("chu"),
        CHV("chv"),
        COR("cor"),
        COS("cos"),
        CRE("cre"),
        CYM("cym"),
        DAN("dan"),
        DEU("deu"),
        DIV("div"),
        DZO("dzo"),
        ELL("ell"),
        ENG("eng"),
        EPO("epo"),
        EST("est"),
        EUS("eus"),
        EWE("ewe"),
        FAO("fao"),
        FAS("fas"),
        FIJ("fij"),
        FIN("fin"),
        FRA("fra"),
        FRY("fry"),
        FUL("ful"),
        GLA("gla"),
        GLE("gle"),
        GLG("glg"),
        GLV("glv"),
        GRN("grn"),
        GUJ("guj"),
        HAT("hat"),
        HAU("hau"),
        HBS("hbs"),
        HEB("heb"),
        HER("her"),
        HIN("hin"),
        HMO("hmo"),
        HRV("hrv"),
        HUN("hun"),
        HYE("hye"),
        IBO("ibo"),
        IDO("ido"),
        III("iii"),
        IKU("iku"),
        ILE("ile"),
        INA("ina"),
        IND("ind"),
        IPK("ipk"),
        ISL("isl"),
        ITA("ita"),
        JAV("jav"),
        JPN("jpn"),
        KAL("kal"),
        KAN("kan"),
        KAS("kas"),
        KAT("kat"),
        KAU("kau"),
        KAZ("kaz"),
        KHM("khm"),
        KIK("kik"),
        KIN("kin"),
        KIR("kir"),
        KOM("kom"),
        KON("kon"),
        KOR("kor"),
        KUA("kua"),
        KUR("kur"),
        LAO("lao"),
        LAT("lat"),
        LAV("lav"),
        LIM("lim"),
        LIN("lin"),
        LIT("lit"),
        LTZ("ltz"),
        LUB("lub"),
        LUG("lug"),
        MAH("mah"),
        MAL("mal"),
        MAR("mar"),
        MKD("mkd"),
        MLG("mlg"),
        MLT("mlt"),
        MON("mon"),
        MRI("mri"),
        MSA("msa"),
        MYA("mya"),
        NAU("nau"),
        NAV("nav"),
        NBL("nbl"),
        NDE("nde"),
        NDO("ndo"),
        NEP("nep"),
        NLD("nld"),
        NNO("nno"),
        NOB("nob"),
        NOR("nor"),
        NYA("nya"),
        OCI("oci"),
        OJI("oji"),
        ORI("ori"),
        ORM("orm"),
        OSS("oss"),
        PAN("pan"),
        PLI("pli"),
        POL("pol"),
        POR("por"),
        PUS("pus"),
        QUE("que"),
        ROH("roh"),
        RON("ron"),
        RUN("run"),
        RUS("rus"),
        SAG("sag"),
        SAN("san"),
        SIN("sin"),
        SLK("slk"),
        SLV("slv"),
        SME("sme"),
        SMO("smo"),
        SNA("sna"),
        SND("snd"),
        SOM("som"),
        SOT("sot"),
        SPA("spa"),
        SQI("sqi"),
        SRD("srd"),
        SRP("srp"),
        SSW("ssw"),
        SUN("sun"),
        SWA("swa"),
        SWE("swe"),
        TAH("tah"),
        TAM("tam"),
        TAT("tat"),
        TEL("tel"),
        TGK("tgk"),
        TGL("tgl"),
        THA("tha"),
        TIR("tir"),
        TON("ton"),
        TSN("tsn"),
        TSO("tso"),
        TUK("tuk"),
        TUR("tur"),
        TWI("twi"),
        UIG("uig"),
        UKR("ukr"),
        URD("urd"),
        UZB("uzb"),
        VEN("ven"),
        VIE("vie"),
        VOL("vol"),
        WLN("wln"),
        WOL("wol"),
        XHO("xho"),
        YID("yid"),
        YOR("yor"),
        ZHA("zha"),
        ZHO("zho"),
        ZUL("zul");
        private final String value;
        private final static Map<String, Dmp.Language> CONSTANTS = new HashMap<String, Dmp.Language>();

        static {
            for (Dmp.Language c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Language(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Dmp.Language fromValue(String value) {
            Dmp.Language constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
