
package org.damap.base.rest.madmp.dto;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * The Dataset Metadata Items Schema
 * <p>
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "description",
    "language",
    "metadata_standard_id"
})
@Generated("jsonschema2pojo")
public class Metadatum {

    /**
     * The Dataset Metadata Description Schema
     * <p>
     * Description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Description")
    private String description;
    /**
     * The Dataset Metadata Language Schema
     * <p>
     * Language of the metadata expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    @JsonPropertyDescription("Language of the metadata expressed using ISO 639-3.")
    private Metadatum.Language language;
    /**
     * The Dataset Metadata Standard ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadata_standard_id")
    private MetadataStandardId metadataStandardId;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * The Dataset Metadata Description Schema
     * <p>
     * Description
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * The Dataset Metadata Description Schema
     * <p>
     * Description
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The Dataset Metadata Language Schema
     * <p>
     * Language of the metadata expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    public Metadatum.Language getLanguage() {
        return language;
    }

    /**
     * The Dataset Metadata Language Schema
     * <p>
     * Language of the metadata expressed using ISO 639-3.
     * (Required)
     * 
     */
    @JsonProperty("language")
    public void setLanguage(Metadatum.Language language) {
        this.language = language;
    }

    /**
     * The Dataset Metadata Standard ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadata_standard_id")
    public MetadataStandardId getMetadataStandardId() {
        return metadataStandardId;
    }

    /**
     * The Dataset Metadata Standard ID Schema
     * <p>
     * 
     * (Required)
     * 
     */
    @JsonProperty("metadata_standard_id")
    public void setMetadataStandardId(MetadataStandardId metadataStandardId) {
        this.metadataStandardId = metadataStandardId;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Metadatum.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(((this.language == null)?"<null>":this.language));
        sb.append(',');
        sb.append("metadataStandardId");
        sb.append('=');
        sb.append(((this.metadataStandardId == null)?"<null>":this.metadataStandardId));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.metadataStandardId == null)? 0 :this.metadataStandardId.hashCode()));
        result = ((result* 31)+((this.language == null)? 0 :this.language.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Metadatum) == false) {
            return false;
        }
        Metadatum rhs = ((Metadatum) other);
        return (((((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description)))&&((this.metadataStandardId == rhs.metadataStandardId)||((this.metadataStandardId!= null)&&this.metadataStandardId.equals(rhs.metadataStandardId))))&&((this.language == rhs.language)||((this.language!= null)&&this.language.equals(rhs.language))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }


    /**
     * The Dataset Metadata Language Schema
     * <p>
     * Language of the metadata expressed using ISO 639-3.
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Language {

        AAR("aar"),
        ABK("abk"),
        AFR("afr"),
        AKA("aka"),
        AMH("amh"),
        ARA("ara"),
        ARG("arg"),
        ASM("asm"),
        AVA("ava"),
        AVE("ave"),
        AYM("aym"),
        AZE("aze"),
        BAK("bak"),
        BAM("bam"),
        BEL("bel"),
        BEN("ben"),
        BIH("bih"),
        BIS("bis"),
        BOD("bod"),
        BOS("bos"),
        BRE("bre"),
        BUL("bul"),
        CAT("cat"),
        CES("ces"),
        CHA("cha"),
        CHE("che"),
        CHU("chu"),
        CHV("chv"),
        COR("cor"),
        COS("cos"),
        CRE("cre"),
        CYM("cym"),
        DAN("dan"),
        DEU("deu"),
        DIV("div"),
        DZO("dzo"),
        ELL("ell"),
        ENG("eng"),
        EPO("epo"),
        EST("est"),
        EUS("eus"),
        EWE("ewe"),
        FAO("fao"),
        FAS("fas"),
        FIJ("fij"),
        FIN("fin"),
        FRA("fra"),
        FRY("fry"),
        FUL("ful"),
        GLA("gla"),
        GLE("gle"),
        GLG("glg"),
        GLV("glv"),
        GRN("grn"),
        GUJ("guj"),
        HAT("hat"),
        HAU("hau"),
        HBS("hbs"),
        HEB("heb"),
        HER("her"),
        HIN("hin"),
        HMO("hmo"),
        HRV("hrv"),
        HUN("hun"),
        HYE("hye"),
        IBO("ibo"),
        IDO("ido"),
        III("iii"),
        IKU("iku"),
        ILE("ile"),
        INA("ina"),
        IND("ind"),
        IPK("ipk"),
        ISL("isl"),
        ITA("ita"),
        JAV("jav"),
        JPN("jpn"),
        KAL("kal"),
        KAN("kan"),
        KAS("kas"),
        KAT("kat"),
        KAU("kau"),
        KAZ("kaz"),
        KHM("khm"),
        KIK("kik"),
        KIN("kin"),
        KIR("kir"),
        KOM("kom"),
        KON("kon"),
        KOR("kor"),
        KUA("kua"),
        KUR("kur"),
        LAO("lao"),
        LAT("lat"),
        LAV("lav"),
        LIM("lim"),
        LIN("lin"),
        LIT("lit"),
        LTZ("ltz"),
        LUB("lub"),
        LUG("lug"),
        MAH("mah"),
        MAL("mal"),
        MAR("mar"),
        MKD("mkd"),
        MLG("mlg"),
        MLT("mlt"),
        MON("mon"),
        MRI("mri"),
        MSA("msa"),
        MYA("mya"),
        NAU("nau"),
        NAV("nav"),
        NBL("nbl"),
        NDE("nde"),
        NDO("ndo"),
        NEP("nep"),
        NLD("nld"),
        NNO("nno"),
        NOB("nob"),
        NOR("nor"),
        NYA("nya"),
        OCI("oci"),
        OJI("oji"),
        ORI("ori"),
        ORM("orm"),
        OSS("oss"),
        PAN("pan"),
        PLI("pli"),
        POL("pol"),
        POR("por"),
        PUS("pus"),
        QUE("que"),
        ROH("roh"),
        RON("ron"),
        RUN("run"),
        RUS("rus"),
        SAG("sag"),
        SAN("san"),
        SIN("sin"),
        SLK("slk"),
        SLV("slv"),
        SME("sme"),
        SMO("smo"),
        SNA("sna"),
        SND("snd"),
        SOM("som"),
        SOT("sot"),
        SPA("spa"),
        SQI("sqi"),
        SRD("srd"),
        SRP("srp"),
        SSW("ssw"),
        SUN("sun"),
        SWA("swa"),
        SWE("swe"),
        TAH("tah"),
        TAM("tam"),
        TAT("tat"),
        TEL("tel"),
        TGK("tgk"),
        TGL("tgl"),
        THA("tha"),
        TIR("tir"),
        TON("ton"),
        TSN("tsn"),
        TSO("tso"),
        TUK("tuk"),
        TUR("tur"),
        TWI("twi"),
        UIG("uig"),
        UKR("ukr"),
        URD("urd"),
        UZB("uzb"),
        VEN("ven"),
        VIE("vie"),
        VOL("vol"),
        WLN("wln"),
        WOL("wol"),
        XHO("xho"),
        YID("yid"),
        YOR("yor"),
        ZHA("zha"),
        ZHO("zho"),
        ZUL("zul");
        private final String value;
        private final static Map<String, Metadatum.Language> CONSTANTS = new HashMap<String, Metadatum.Language>();

        static {
            for (Metadatum.Language c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Language(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Metadatum.Language fromValue(String value) {
            Metadatum.Language constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
