/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.damap.base.repo.DmpRepo;
import org.damap.base.repo.InternalStorageTranslationRepo;
import org.jboss.logging.Logger;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;

public abstract class AbstractTemplateExportFunctions {
    @Generated
    private static final Logger log = Logger.getLogger(AbstractTemplateExportFunctions.class);
    @Inject
    DmpRepo dmpRepo;
    @Inject
    InternalStorageTranslationRepo internalStorageTranslationRepo;
    protected final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public XWPFDocument loadTemplate(InputStream template, String startChar, String endChar) throws Exception {
        XWPFDocument document = new XWPFDocument(template);
        return this.templateFormatting(document, startChar, endChar);
    }

    static void replaceInParagraphs(List<XWPFParagraph> xwpfParagraphs, Map<String, String> replacements) {
        for (XWPFParagraph xwpfParagraph : xwpfParagraphs) {
            List xwpfRuns = xwpfParagraph.getRuns();
            for (XWPFRun xwpfRun : xwpfRuns) {
                String xwpfRunText = xwpfRun.getText(xwpfRun.getTextPosition());
                for (Map.Entry<String, String> entry : replacements.entrySet()) {
                    if (xwpfRunText == null || !xwpfRunText.contains(entry.getKey())) continue;
                    if (entry.getValue().contains(";")) {
                        String[] value = entry.getValue().split(";");
                        for (int i = 0; i < value.length; ++i) {
                            xwpfParagraph.setAlignment(ParagraphAlignment.LEFT);
                            xwpfRun.setText(value[i].trim());
                            if (i >= value.length - 1) continue;
                            xwpfRun.addBreak();
                            xwpfRun.addBreak();
                        }
                        xwpfRunText = "";
                        continue;
                    }
                    if (entry.getKey().equals("[projectname]") && entry.getValue().contains("#oversize")) {
                        xwpfRun.setFontSize(xwpfRun.getFontSize() - 4);
                        xwpfRunText = xwpfRunText.replace(entry.getKey(), entry.getValue().replace("#oversize", ""));
                        continue;
                    }
                    if (entry.getValue().contains("#color_green")) {
                        xwpfRun.setColor("92D050");
                        xwpfRunText = xwpfRunText.replace(entry.getKey(), entry.getValue().replace("#color_green", ""));
                        continue;
                    }
                    xwpfRunText = xwpfRunText.replace(entry.getKey(), entry.getValue());
                }
                xwpfRun.setText(xwpfRunText, 0);
            }
        }
    }

    public void addReplacement(Map<String, String> replacements, String variable, Object dmpContent) {
        String content;
        String string = content = dmpContent == null ? "" : String.valueOf(dmpContent);
        if (dmpContent != null && (dmpContent.getClass() == Timestamp.class || dmpContent.getClass() == Date.class)) {
            content = this.formatter.format(dmpContent);
        }
        replacements.put(variable, content);
    }

    public XWPFTableRow insertNewTableRow(XWPFTableRow sourceTableRow, int pos) throws XmlException, IOException {
        XWPFTable table = sourceTableRow.getTable();
        CTRow newCTRrow = CTRow.Factory.parse((InputStream)sourceTableRow.getCtRow().newInputStream());
        XWPFTableRow tableRow = new XWPFTableRow(newCTRrow, table);
        table.addRow(tableRow, pos);
        return tableRow;
    }

    static void insertTableCells(XWPFTable table, XWPFTableRow newRow, ArrayList<String> cellContent) {
        List cells = newRow.getTableCells();
        for (XWPFTableCell cell : cells) {
            for (XWPFParagraph paragraph : cell.getParagraphs()) {
                for (XWPFRun run : paragraph.getRuns()) {
                    run.setText(cellContent.get(cells.indexOf(cell)), 0);
                }
            }
        }
        AbstractTemplateExportFunctions.commitTableRows(table);
    }

    static void replaceTableVariables(XWPFTable table, Map<String, String> replacements) {
        List tableRows = table.getRows();
        for (XWPFTableRow xwpfTableRow : tableRows) {
            List tableCells = xwpfTableRow.getTableCells();
            for (XWPFTableCell xwpfTableCell : tableCells) {
                List xwpfParagraphs = xwpfTableCell.getParagraphs();
                AbstractTemplateExportFunctions.replaceInParagraphs(xwpfParagraphs, replacements);
            }
        }
    }

    static void commitTableRows(XWPFTable table) {
        int rowNr = 0;
        for (XWPFTableRow tableRow : table.getRows()) {
            table.getCTTbl().setTrArray(rowNr++, tableRow.getCtRow());
        }
    }

    public void replaceTextInFooter(XWPFDocument doc, Map<String, String> replacements) {
        for (XWPFFooter footer : doc.getFooterList()) {
            for (XWPFParagraph xwpfParagraph : footer.getParagraphs()) {
                for (XWPFRun xwpfRun : xwpfParagraph.getRuns()) {
                    String xwpfRunText = xwpfRun.getText(xwpfRun.getTextPosition());
                    for (Map.Entry<String, String> entry : replacements.entrySet()) {
                        if (xwpfRunText == null || !xwpfRunText.contains(entry.getKey())) continue;
                        xwpfRunText = xwpfRunText.replace(entry.getKey(), entry.getValue());
                    }
                    xwpfRun.setText(xwpfRunText, 0);
                }
            }
        }
    }

    public String joinWithComma(List<String> variableList) {
        return String.join((CharSequence)", ", variableList);
    }

    public String joinWithCommaAnd(List<String> variableList) {
        return switch (variableList.size()) {
            case 0 -> "";
            case 1 -> variableList.get(0);
            default -> String.join((CharSequence)", ", variableList.subList(0, variableList.size() - 1)) + " and " + variableList.get(variableList.size() - 1);
        };
    }

    public XWPFDocument templateFormatting(XWPFDocument document, String startChar, String endChar) throws Exception {
        log.info((Object)"Formatting template document");
        this.formattingParagraph(document.getParagraphs(), startChar, endChar);
        this.formattingTable(document.getTables(), startChar, endChar);
        if (document.getFooterList() != null) {
            for (XWPFFooter footer : document.getFooterList()) {
                this.formattingParagraph(footer.getParagraphs(), startChar, endChar);
            }
        }
        return document;
    }

    public void formattingTable(List<XWPFTable> xwpfTables, String startChar, String endChar) {
        if (xwpfTables != null) {
            for (XWPFTable xwpfTable : xwpfTables) {
                for (XWPFTableRow row : xwpfTable.getRows()) {
                    for (XWPFTableCell cell : row.getTableCells()) {
                        this.formattingParagraph(cell.getParagraphs(), startChar, endChar);
                        this.formattingTable(cell.getTables(), startChar, endChar);
                    }
                }
            }
        }
    }

    public void formattingParagraph(List<XWPFParagraph> xwpfParagraphs, String startChar, String endChar) {
        StringBuilder sb = new StringBuilder("");
        boolean mergeRun = false;
        ArrayList<Integer> removeRunIndex = new ArrayList<Integer>();
        for (XWPFParagraph xwpfParagraph : xwpfParagraphs) {
            List xwpfRuns = xwpfParagraph.getRuns();
            for (XWPFRun xwpfRun : xwpfRuns) {
                String xwpfRunText = xwpfRun.getText(xwpfRun.getTextPosition());
                if (xwpfRunText == null) continue;
                if (xwpfRunText.contains(startChar)) {
                    if (xwpfRunText.contains(endChar)) continue;
                    removeRunIndex.add(xwpfRuns.indexOf(xwpfRun));
                    mergeRun = true;
                    if (sb.length() > 0) {
                        sb.delete(0, sb.length());
                    }
                    sb.append(xwpfRunText);
                    continue;
                }
                if (!mergeRun) continue;
                sb.append(xwpfRunText);
                if (xwpfRunText.contains(endChar)) {
                    mergeRun = false;
                    xwpfRun.setText(sb.toString(), 0);
                    continue;
                }
                removeRunIndex.add(xwpfRuns.indexOf(xwpfRun));
            }
            if (removeRunIndex.isEmpty()) continue;
            Collections.sort(removeRunIndex, Collections.reverseOrder());
            for (Integer runIndex : removeRunIndex) {
                xwpfParagraphs.get(xwpfParagraphs.indexOf(xwpfParagraph)).removeRun(runIndex.intValue());
            }
            removeRunIndex.clear();
        }
    }

    public void removeTable(XWPFDocument doc, XWPFTable table) {
        int pos = doc.getPosOfTable(table);
        if (pos != -1) {
            doc.removeBodyElement(pos);
        } else {
            this.removeNestedTable(doc, table);
        }
    }

    private void removeNestedTable(XWPFDocument doc, XWPFTable table) {
        for (XWPFTableCell cell : this.getAllOuterTableCells(doc)) {
            for (XWPFTable nestedTable : cell.getTables()) {
                if (!nestedTable.equals(table)) continue;
                int pos = cell.getTables().indexOf(nestedTable);
                try {
                    Field beField = cell.getClass().getDeclaredField("tables");
                    beField.setAccessible(true);
                    ((List)beField.get(cell)).remove(pos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cell.getCTTc().removeTbl(pos);
                return;
            }
        }
    }

    public void removeTableAndParagraphAbove(XWPFDocument doc, XWPFTable table) {
        if (doc.getPosOfTable(table) != -1) {
            int paragraphPos = doc.getPosOfTable(table) - 1;
            if (((IBodyElement)doc.getBodyElements().get(paragraphPos)).getElementType().equals((Object)BodyElementType.PARAGRAPH)) {
                doc.removeBodyElement(paragraphPos);
            }
        } else {
            for (XWPFTableCell cell : this.getAllOuterTableCells(doc)) {
                for (XWPFTable nestedTable : cell.getTables()) {
                    if (!nestedTable.equals(table)) continue;
                    int paragraphPos = cell.getBodyElements().indexOf(table) - 1;
                    if (!((IBodyElement)cell.getBodyElements().get(paragraphPos)).getElementType().equals((Object)BodyElementType.PARAGRAPH)) continue;
                    XWPFParagraph paragraphToRemove = (XWPFParagraph)cell.getBodyElements().get(paragraphPos);
                    cell.removeParagraph(cell.getParagraphs().indexOf(paragraphToRemove));
                }
            }
        }
        this.removeTable(doc, table);
    }

    public List<XWPFTableCell> getAllOuterTableCells(XWPFDocument doc) {
        ArrayList<XWPFTableCell> tableCells = new ArrayList<XWPFTableCell>();
        for (XWPFTable outerTable : doc.getTables()) {
            for (XWPFTableRow row : outerTable.getRows()) {
                tableCells.addAll(row.getTableCells());
            }
        }
        return tableCells;
    }

    public List<XWPFTable> getAllTables(XWPFDocument doc) {
        ArrayList<XWPFTable> tables = new ArrayList<XWPFTable>(doc.getTables());
        for (XWPFTableCell cell : this.getAllOuterTableCells(doc)) {
            tables.addAll(cell.getTables());
        }
        return tables;
    }

    void turnRunIntoHyperlinkRun(XWPFRun run, String URI2) {
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        int runPos = paragraph.getRuns().indexOf(run);
        int runsAfterHyperlinkRun = paragraph.getRuns().size() - runPos - 1;
        XWPFHyperlinkRun hyperlink = paragraph.createHyperlinkRun(URI2);
        hyperlink.setStyle("Hyperlink");
        hyperlink.setFontSize(run.getFontSize());
        hyperlink.setFontFamily(run.getFontFamily());
        hyperlink.setText(run.getText(0));
        paragraph.removeRun(runPos);
        for (int i = 0; i < runsAfterHyperlinkRun; ++i) {
            XWPFRun runToRemove = (XWPFRun)paragraph.getRuns().get(runPos);
            XWPFRun createdRun = paragraph.createRun();
            createdRun.getCTR().setRPr(runToRemove.getCTR().getRPr());
            createdRun.setText(runToRemove.getText(0));
            paragraph.removeRun(runPos);
        }
    }
}

