/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import jakarta.enterprise.context.RequestScoped;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.damap.base.conversion.AbstractTemplateExportScienceEuropeComponents;
import org.jboss.logging.Logger;

@RequestScoped
public class ExportFWFTemplate
extends AbstractTemplateExportScienceEuropeComponents {
    @Generated
    private static final Logger log = Logger.getLogger(ExportFWFTemplate.class);

    public XWPFDocument exportTemplate(long dmpId) {
        log.info((Object)("Exporting FWF document for DMP with ID: " + dmpId));
        this.exportSetup(dmpId);
        String startChar = "[";
        String endChar = "]";
        this.prop = this.templateFileBrokerService.getFWFTemplateResource();
        XWPFDocument document = null;
        try {
            document = this.loadTemplate(this.templateFileBrokerService.loadFWFTemplate(), startChar, endChar);
        }
        catch (Exception e) {
            log.error((Object)"Template file not found!");
            return null;
        }
        this.xwpfParagraphs = document.getParagraphs();
        this.xwpfTables = document.getTables();
        XWPFTable templateTable = (XWPFTable)this.xwpfTables.get(3);
        List<XWPFTable> templateXwpfTables = this.parseContentTables(templateTable);
        this.loadScienceEuropeContent();
        ExportFWFTemplate.replaceInParagraphs(this.xwpfParagraphs, this.replacements);
        ExportFWFTemplate.replaceTableVariables(templateTable, this.replacements);
        this.tableContent(document, templateXwpfTables);
        return document;
    }

    private List<XWPFTable> parseContentTables(XWPFTable templateTable) {
        ArrayList<XWPFTable> templateXwpfTables = new ArrayList<XWPFTable>();
        for (XWPFTableRow row : templateTable.getRows()) {
            if (row.getTableCells().size() <= 1) continue;
            templateXwpfTables.addAll(row.getCell(1).getTables());
        }
        return templateXwpfTables;
    }
}

