/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.conversion;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.damap.base.conversion.ExportFWFTemplate;
import org.damap.base.conversion.ExportHorizonEuropeTemplate;
import org.damap.base.conversion.ExportScienceEuropeTemplate;
import org.damap.base.conversion.TemplateSelectorServiceImpl;
import org.damap.base.enums.ETemplateType;
import org.damap.base.rest.dmp.service.DmpService;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ExportTemplateBroker {
    @Generated
    private static final Logger log = Logger.getLogger(ExportTemplateBroker.class);
    private final DmpService dmpService;
    private final ExportScienceEuropeTemplate exportScienceEuropeTemplate;
    private final ExportFWFTemplate exportFWFTemplate;
    private final ExportHorizonEuropeTemplate exportHorizonEuropeTemplate;
    private final TemplateSelectorServiceImpl templateSelectorService;

    @Inject
    public ExportTemplateBroker(DmpService dmpService, ExportScienceEuropeTemplate exportScienceEuropeTemplate, ExportFWFTemplate exportFWFTemplate, ExportHorizonEuropeTemplate exportHorizonEuropeTemplate, TemplateSelectorServiceImpl templateSelectorService) {
        this.dmpService = dmpService;
        this.exportScienceEuropeTemplate = exportScienceEuropeTemplate;
        this.exportFWFTemplate = exportFWFTemplate;
        this.exportHorizonEuropeTemplate = exportHorizonEuropeTemplate;
        this.templateSelectorService = templateSelectorService;
    }

    public XWPFDocument exportTemplate(long dmpId) {
        return this.exportTemplateByType(dmpId, this.templateSelectorService.selectTemplate(this.dmpService.getDmpById(dmpId)));
    }

    public XWPFDocument exportTemplateByType(long dmpId, ETemplateType type) {
        switch (type) {
            case FWF: {
                return this.exportFWFTemplate.exportTemplate(dmpId);
            }
            case HORIZON_EUROPE: {
                return this.exportHorizonEuropeTemplate.exportTemplate(dmpId);
            }
        }
        return this.exportScienceEuropeTemplate.exportTemplate(dmpId);
    }
}

