/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.Contributor;
import org.damap.base.domain.Distribution;
import org.damap.base.domain.Dmp;
import org.damap.base.domain.Identifier;
import org.damap.base.domain.Repository;
import org.damap.base.enums.EAccessRight;
import org.damap.base.enums.EDataAccessType;
import org.damap.base.enums.EDataSource;
import org.damap.base.enums.EDataType;
import org.damap.base.enums.ELicense;
import org.hibernate.envers.Audited;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Audited
public class Dataset
extends PanacheEntity {
    @Version
    private long version;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dmp_id")
    private Dmp dmp;
    private String title;
    @ElementCollection(targetClass=EDataType.class, fetch=FetchType.EAGER)
    @CollectionTable(name="data_type")
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private List<EDataType> type;
    @Column(name="data_size")
    private Long size;
    @Column(name="description", length=0x7FFFFFFF)
    private String description;
    @Column(name="personal_data")
    private Boolean personalData;
    @Column(name="sensitive_data")
    private Boolean sensitiveData;
    @Column(name="legal_restrictions")
    private Boolean legalRestrictions;
    @Enumerated(value=EnumType.STRING)
    @Column(name="license")
    private ELicense license;
    @Column(name="start_date")
    private Date start;
    @Column(name="reference_hash")
    private String referenceHash;
    @Enumerated(value=EnumType.STRING)
    @Column(name="data_access")
    private EDataAccessType dataAccess;
    @OneToMany(mappedBy="dataset", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Distribution> distributionList = new ArrayList<Distribution>();
    @Enumerated(value=EnumType.STRING)
    @Column(name="sel_project_members_access")
    private EAccessRight selectedProjectMembersAccess;
    @Enumerated(value=EnumType.STRING)
    @Column(name="other_project_members_access")
    private EAccessRight otherProjectMembersAccess;
    @Enumerated(value=EnumType.STRING)
    @Column(name="public_access")
    private EAccessRight publicAccess;
    @Column(name="delete_data")
    private Boolean delete;
    @Column(name="date_of_deletion")
    private Date dateOfDeletion;
    @Column(name="reason_for_deletion")
    private String reasonForDeletion;
    @ManyToOne
    @JoinColumn(name="deletion_person_id")
    private Contributor deletionPerson;
    @Column(name="retention_period")
    private Integer retentionPeriod;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="dataset_pid")
    private Identifier datasetIdentifier;
    @Enumerated(value=EnumType.STRING)
    @Column(name="dataset_source")
    private EDataSource source;

    public List<Repository> getRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Distribution distribution : this.getDistributionList()) {
            if (!Repository.class.isAssignableFrom(((Object)((Object)distribution.getHost())).getClass())) continue;
            repositories.add((Repository)distribution.getHost());
        }
        return repositories;
    }

    public Long getId() {
        return this.id;
    }

    @Generated
    public Dataset() {
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Dmp getDmp() {
        return this.dmp;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<EDataType> getType() {
        return this.type;
    }

    @Generated
    public Long getSize() {
        return this.size;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getPersonalData() {
        return this.personalData;
    }

    @Generated
    public Boolean getSensitiveData() {
        return this.sensitiveData;
    }

    @Generated
    public Boolean getLegalRestrictions() {
        return this.legalRestrictions;
    }

    @Generated
    public ELicense getLicense() {
        return this.license;
    }

    @Generated
    public Date getStart() {
        return this.start;
    }

    @Generated
    public String getReferenceHash() {
        return this.referenceHash;
    }

    @Generated
    public EDataAccessType getDataAccess() {
        return this.dataAccess;
    }

    @Generated
    public List<Distribution> getDistributionList() {
        return this.distributionList;
    }

    @Generated
    public EAccessRight getSelectedProjectMembersAccess() {
        return this.selectedProjectMembersAccess;
    }

    @Generated
    public EAccessRight getOtherProjectMembersAccess() {
        return this.otherProjectMembersAccess;
    }

    @Generated
    public EAccessRight getPublicAccess() {
        return this.publicAccess;
    }

    @Generated
    public Boolean getDelete() {
        return this.delete;
    }

    @Generated
    public Date getDateOfDeletion() {
        return this.dateOfDeletion;
    }

    @Generated
    public String getReasonForDeletion() {
        return this.reasonForDeletion;
    }

    @Generated
    public Contributor getDeletionPerson() {
        return this.deletionPerson;
    }

    @Generated
    public Integer getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @Generated
    public Identifier getDatasetIdentifier() {
        return this.datasetIdentifier;
    }

    @Generated
    public EDataSource getSource() {
        return this.source;
    }

    @JsonIgnore
    @Generated
    public void setDmp(Dmp dmp) {
        this.dmp = dmp;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setType(List<EDataType> type) {
        this.type = type;
    }

    @Generated
    public void setSize(Long size) {
        this.size = size;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setPersonalData(Boolean personalData) {
        this.personalData = personalData;
    }

    @Generated
    public void setSensitiveData(Boolean sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    @Generated
    public void setLegalRestrictions(Boolean legalRestrictions) {
        this.legalRestrictions = legalRestrictions;
    }

    @Generated
    public void setLicense(ELicense license) {
        this.license = license;
    }

    @Generated
    public void setStart(Date start) {
        this.start = start;
    }

    @Generated
    public void setReferenceHash(String referenceHash) {
        this.referenceHash = referenceHash;
    }

    @Generated
    public void setDataAccess(EDataAccessType dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Generated
    public void setDistributionList(List<Distribution> distributionList) {
        this.distributionList = distributionList;
    }

    @Generated
    public void setSelectedProjectMembersAccess(EAccessRight selectedProjectMembersAccess) {
        this.selectedProjectMembersAccess = selectedProjectMembersAccess;
    }

    @Generated
    public void setOtherProjectMembersAccess(EAccessRight otherProjectMembersAccess) {
        this.otherProjectMembersAccess = otherProjectMembersAccess;
    }

    @Generated
    public void setPublicAccess(EAccessRight publicAccess) {
        this.publicAccess = publicAccess;
    }

    @Generated
    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    @Generated
    public void setDateOfDeletion(Date dateOfDeletion) {
        this.dateOfDeletion = dateOfDeletion;
    }

    @Generated
    public void setReasonForDeletion(String reasonForDeletion) {
        this.reasonForDeletion = reasonForDeletion;
    }

    @Generated
    public void setDeletionPerson(Contributor deletionPerson) {
        this.deletionPerson = deletionPerson;
    }

    @Generated
    public void setRetentionPeriod(Integer retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    @Generated
    public void setDatasetIdentifier(Identifier datasetIdentifier) {
        this.datasetIdentifier = datasetIdentifier;
    }

    @Generated
    public void setSource(EDataSource source) {
        this.source = source;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Boolean this$personalData = this.getPersonalData();
        Boolean other$personalData = other.getPersonalData();
        if (this$personalData == null ? other$personalData != null : !((Object)this$personalData).equals(other$personalData)) {
            return false;
        }
        Boolean this$sensitiveData = this.getSensitiveData();
        Boolean other$sensitiveData = other.getSensitiveData();
        if (this$sensitiveData == null ? other$sensitiveData != null : !((Object)this$sensitiveData).equals(other$sensitiveData)) {
            return false;
        }
        Boolean this$legalRestrictions = this.getLegalRestrictions();
        Boolean other$legalRestrictions = other.getLegalRestrictions();
        if (this$legalRestrictions == null ? other$legalRestrictions != null : !((Object)this$legalRestrictions).equals(other$legalRestrictions)) {
            return false;
        }
        Boolean this$delete = this.getDelete();
        Boolean other$delete = other.getDelete();
        if (this$delete == null ? other$delete != null : !((Object)this$delete).equals(other$delete)) {
            return false;
        }
        Integer this$retentionPeriod = this.getRetentionPeriod();
        Integer other$retentionPeriod = other.getRetentionPeriod();
        if (this$retentionPeriod == null ? other$retentionPeriod != null : !((Object)this$retentionPeriod).equals(other$retentionPeriod)) {
            return false;
        }
        Long this$$getId = this.getId();
        Long other$$getId = other.getId();
        if (this$$getId == null ? other$$getId != null : !((Object)this$$getId).equals(other$$getId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<EDataType> this$type = this.getType();
        List<EDataType> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ELicense this$license = this.getLicense();
        ELicense other$license = other.getLicense();
        if (this$license == null ? other$license != null : !((Object)((Object)this$license)).equals((Object)other$license)) {
            return false;
        }
        Date this$start = this.getStart();
        Date other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        String this$referenceHash = this.getReferenceHash();
        String other$referenceHash = other.getReferenceHash();
        if (this$referenceHash == null ? other$referenceHash != null : !this$referenceHash.equals(other$referenceHash)) {
            return false;
        }
        EDataAccessType this$dataAccess = this.getDataAccess();
        EDataAccessType other$dataAccess = other.getDataAccess();
        if (this$dataAccess == null ? other$dataAccess != null : !((Object)((Object)this$dataAccess)).equals((Object)other$dataAccess)) {
            return false;
        }
        List<Distribution> this$distributionList = this.getDistributionList();
        List<Distribution> other$distributionList = other.getDistributionList();
        if (this$distributionList == null ? other$distributionList != null : !((Object)this$distributionList).equals(other$distributionList)) {
            return false;
        }
        EAccessRight this$selectedProjectMembersAccess = this.getSelectedProjectMembersAccess();
        EAccessRight other$selectedProjectMembersAccess = other.getSelectedProjectMembersAccess();
        if (this$selectedProjectMembersAccess == null ? other$selectedProjectMembersAccess != null : !((Object)((Object)this$selectedProjectMembersAccess)).equals((Object)other$selectedProjectMembersAccess)) {
            return false;
        }
        EAccessRight this$otherProjectMembersAccess = this.getOtherProjectMembersAccess();
        EAccessRight other$otherProjectMembersAccess = other.getOtherProjectMembersAccess();
        if (this$otherProjectMembersAccess == null ? other$otherProjectMembersAccess != null : !((Object)((Object)this$otherProjectMembersAccess)).equals((Object)other$otherProjectMembersAccess)) {
            return false;
        }
        EAccessRight this$publicAccess = this.getPublicAccess();
        EAccessRight other$publicAccess = other.getPublicAccess();
        if (this$publicAccess == null ? other$publicAccess != null : !((Object)((Object)this$publicAccess)).equals((Object)other$publicAccess)) {
            return false;
        }
        Date this$dateOfDeletion = this.getDateOfDeletion();
        Date other$dateOfDeletion = other.getDateOfDeletion();
        if (this$dateOfDeletion == null ? other$dateOfDeletion != null : !((Object)this$dateOfDeletion).equals(other$dateOfDeletion)) {
            return false;
        }
        String this$reasonForDeletion = this.getReasonForDeletion();
        String other$reasonForDeletion = other.getReasonForDeletion();
        if (this$reasonForDeletion == null ? other$reasonForDeletion != null : !this$reasonForDeletion.equals(other$reasonForDeletion)) {
            return false;
        }
        Contributor this$deletionPerson = this.getDeletionPerson();
        Contributor other$deletionPerson = other.getDeletionPerson();
        if (this$deletionPerson == null ? other$deletionPerson != null : !((Object)((Object)this$deletionPerson)).equals((Object)other$deletionPerson)) {
            return false;
        }
        Identifier this$datasetIdentifier = this.getDatasetIdentifier();
        Identifier other$datasetIdentifier = other.getDatasetIdentifier();
        if (this$datasetIdentifier == null ? other$datasetIdentifier != null : !((Object)((Object)this$datasetIdentifier)).equals((Object)other$datasetIdentifier)) {
            return false;
        }
        EDataSource this$source = this.getSource();
        EDataSource other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dataset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Boolean $personalData = this.getPersonalData();
        result = result * 59 + ($personalData == null ? 43 : ((Object)$personalData).hashCode());
        Boolean $sensitiveData = this.getSensitiveData();
        result = result * 59 + ($sensitiveData == null ? 43 : ((Object)$sensitiveData).hashCode());
        Boolean $legalRestrictions = this.getLegalRestrictions();
        result = result * 59 + ($legalRestrictions == null ? 43 : ((Object)$legalRestrictions).hashCode());
        Boolean $delete = this.getDelete();
        result = result * 59 + ($delete == null ? 43 : ((Object)$delete).hashCode());
        Integer $retentionPeriod = this.getRetentionPeriod();
        result = result * 59 + ($retentionPeriod == null ? 43 : ((Object)$retentionPeriod).hashCode());
        Long $$getId = this.getId();
        result = result * 59 + ($$getId == null ? 43 : ((Object)$$getId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<EDataType> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ELicense $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : ((Object)((Object)$license)).hashCode());
        Date $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        String $referenceHash = this.getReferenceHash();
        result = result * 59 + ($referenceHash == null ? 43 : $referenceHash.hashCode());
        EDataAccessType $dataAccess = this.getDataAccess();
        result = result * 59 + ($dataAccess == null ? 43 : ((Object)((Object)$dataAccess)).hashCode());
        List<Distribution> $distributionList = this.getDistributionList();
        result = result * 59 + ($distributionList == null ? 43 : ((Object)$distributionList).hashCode());
        EAccessRight $selectedProjectMembersAccess = this.getSelectedProjectMembersAccess();
        result = result * 59 + ($selectedProjectMembersAccess == null ? 43 : ((Object)((Object)$selectedProjectMembersAccess)).hashCode());
        EAccessRight $otherProjectMembersAccess = this.getOtherProjectMembersAccess();
        result = result * 59 + ($otherProjectMembersAccess == null ? 43 : ((Object)((Object)$otherProjectMembersAccess)).hashCode());
        EAccessRight $publicAccess = this.getPublicAccess();
        result = result * 59 + ($publicAccess == null ? 43 : ((Object)((Object)$publicAccess)).hashCode());
        Date $dateOfDeletion = this.getDateOfDeletion();
        result = result * 59 + ($dateOfDeletion == null ? 43 : ((Object)$dateOfDeletion).hashCode());
        String $reasonForDeletion = this.getReasonForDeletion();
        result = result * 59 + ($reasonForDeletion == null ? 43 : $reasonForDeletion.hashCode());
        Contributor $deletionPerson = this.getDeletionPerson();
        result = result * 59 + ($deletionPerson == null ? 43 : ((Object)((Object)$deletionPerson)).hashCode());
        Identifier $datasetIdentifier = this.getDatasetIdentifier();
        result = result * 59 + ($datasetIdentifier == null ? 43 : ((Object)((Object)$datasetIdentifier)).hashCode());
        EDataSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Dataset(version=" + this.getVersion() + ", title=" + this.getTitle() + ", type=" + this.getType() + ", size=" + this.getSize() + ", description=" + this.getDescription() + ", personalData=" + this.getPersonalData() + ", sensitiveData=" + this.getSensitiveData() + ", legalRestrictions=" + this.getLegalRestrictions() + ", license=" + this.getLicense() + ", start=" + this.getStart() + ", referenceHash=" + this.getReferenceHash() + ", dataAccess=" + this.getDataAccess() + ", distributionList=" + this.getDistributionList() + ", selectedProjectMembersAccess=" + this.getSelectedProjectMembersAccess() + ", otherProjectMembersAccess=" + this.getOtherProjectMembersAccess() + ", publicAccess=" + this.getPublicAccess() + ", delete=" + this.getDelete() + ", dateOfDeletion=" + this.getDateOfDeletion() + ", reasonForDeletion=" + this.getReasonForDeletion() + ", deletionPerson=" + this.getDeletionPerson() + ", retentionPeriod=" + this.getRetentionPeriod() + ", datasetIdentifier=" + this.getDatasetIdentifier() + ", source=" + this.getSource() + ")";
    }
}

