/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.domain;

public enum DatasetSizeRange {
    LESS_THAN_100MB(0L, 99999999L, "< 100 MB"),
    FROM_100MB_TO_1GB(100000000L, 999999999L, "100 - 1000 MB"),
    FROM_1GB_TO_5GB(1000000000L, 4999999999L, "1 - 5 GB"),
    FROM_5GB_TO_20GB(5000000000L, 19999999999L, "5 - 20 GB"),
    FROM_20GB_TO_50GB(20000000000L, 49999999999L, "20 - 50 GB"),
    FROM_50GB_TO_100GB(50000000000L, 99999999999L, "50 - 100 GB"),
    FROM_100GB_TO_500GB(100000000000L, 499999999999L, "100 - 500 GB"),
    FROM_500GB_TO_1TB(500000000000L, 999999999999L, "500 - 1000 GB"),
    FROM_1TB_TO_5TB(1000000000000L, 4999999999999L, "1 - 5 TB"),
    FROM_5TB_TO_10TB(5000000000000L, 9999999999999L, "5 - 10 TB"),
    FROM_10TB_TO_100TB(10000000000000L, 99999999999999L, "10 - 100 TB"),
    FROM_100TB_TO_500TB(100000000000000L, 499999999999999L, "100 - 500 TB"),
    FROM_500TB_TO_1PB(500000000000000L, 999999999999999L, "500 - 1000 TB"),
    MORE_THAN_1PB(1000000000000000L, Long.MAX_VALUE, "> 1 PB"),
    UNKNOWN(-1L, -1L, "I don't know yet");

    private final long minSize;
    private final long maxSize;
    private final String label;

    private DatasetSizeRange(long minSize, long maxSize, String label) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.label = label;
    }

    public long getMinSize() {
        return this.minSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public String getLabel() {
        return this.label;
    }

    public static String getLabelForSize(long size) {
        for (DatasetSizeRange range : DatasetSizeRange.values()) {
            if (size < range.getMinSize() || size > range.getMaxSize()) continue;
            return range.getLabel();
        }
        return "Unknown size";
    }
}

