/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.r3data;

import generated.Repository;
import io.quarkus.security.Authenticated;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.damap.base.r3data.RepositoriesService;
import org.damap.base.r3data.dto.RepositoryDetails;
import org.damap.base.r3data.mapper.RepositoryMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.jaxrs.PathParam;

@Path(value="/api/repositories")
@Authenticated
@Produces(value={"application/json"})
public class RepositoriesResource {
    @Generated
    private static final Logger log = Logger.getLogger(RepositoriesResource.class);
    @Inject
    RepositoriesService repositoriesService;

    @GET
    public List<Repository> getAll() {
        log.info((Object)"Get all repositories");
        return this.repositoriesService.getAll();
    }

    @GET
    @Path(value="/recommended")
    public List<RepositoryDetails> getRecommended() {
        log.info((Object)"Get recommended repositories");
        return this.repositoriesService.getRecommended();
    }

    @GET
    @Path(value="/{id}")
    public RepositoryDetails getById(@PathParam String id) {
        log.info((Object)("Get repository with id: " + id));
        return RepositoryMapper.mapToRepositoryDetails(this.repositoriesService.getById(id), id);
    }

    @GET
    @Path(value="/search")
    public List<Repository> search(@Context UriInfo uriInfo) {
        log.info((Object)("Search repositories: " + uriInfo.getQueryParameters()));
        MultivaluedMap params = uriInfo.getQueryParameters();
        return this.repositoriesService.search((MultivaluedMap<String, String>)params);
    }
}

