/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.r3data;

import generated.Repository;
import io.quarkus.cache.CacheResult;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.damap.base.enums.EIdentifierType;
import org.damap.base.r3data.RepositoriesRemoteResource;
import org.damap.base.r3data.dto.RepositoryDetails;
import org.damap.base.r3data.mapper.RepositoryMapper;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;
import org.re3data.schema._2_2.Re3Data;

@ApplicationScoped
public class RepositoriesService {
    @Generated
    private static final Logger log = Logger.getLogger(RepositoriesService.class);
    @Inject
    @RestClient
    RepositoriesRemoteResource repositoriesRemoteResource;
    @ConfigProperty(name="damap.repositories.recommendation")
    String[] repositoriesRecommendation;

    @CacheResult(cacheName="repositories")
    public List<Repository> getAll() {
        return this.repositoriesRemoteResource.getAll();
    }

    @CacheResult(cacheName="recommendedRepositories")
    public List<RepositoryDetails> getRecommended() {
        ArrayList<RepositoryDetails> recommendedRepositories = new ArrayList<RepositoryDetails>();
        for (String id : this.repositoriesRecommendation) {
            if (!id.startsWith("r3d")) continue;
            try {
                Re3Data repo = this.getById(id);
                recommendedRepositories.add(RepositoryMapper.mapToRepositoryDetails(repo, id));
            }
            catch (Exception e) {
                log.infov("Failed to retrieve repository for ID {0}, error: {1}", (Object)id, (Object)e.getMessage());
            }
        }
        return recommendedRepositories;
    }

    @CacheResult(cacheName="repository")
    public Re3Data getById(String id) {
        return this.repositoriesRemoteResource.getById(id);
    }

    public List<Repository> search(MultivaluedMap<String, String> params) {
        List subjects = (List)params.get((Object)"subjects");
        List contentTypes = (List)params.get((Object)"contentTypes");
        List certificates = (List)params.get((Object)"certificates");
        List countries = (List)params.get((Object)"countries");
        List pidSystems = (List)params.get((Object)"pidSystems");
        List aidSystems = (List)params.get((Object)"aidSystems");
        List repositoryAccess = (List)params.get((Object)"repositoryAccess");
        List dataAccess = (List)params.get((Object)"dataAccess");
        List dataUpload = (List)params.get((Object)"dataUpload");
        List dataLicenses = (List)params.get((Object)"dataLicenses");
        List repositoryTypes = (List)params.get((Object)"repositoryTypes");
        List institutionTypes = (List)params.get((Object)"institutionTypes");
        List versioning = (List)params.get((Object)"versioning");
        List metadataStandards = (List)params.get((Object)"metadataStandards");
        return this.repositoriesRemoteResource.search(subjects, contentTypes, countries, certificates, pidSystems, aidSystems, repositoryAccess, dataAccess, dataUpload, dataLicenses, repositoryTypes, institutionTypes, versioning, metadataStandards);
    }

    public String getDescription(String id) {
        return RepositoryMapper.mapToRepositoryDetails(this.getById(id), id).getDescription();
    }

    public String getRepositoryURL(String id) {
        return RepositoryMapper.mapToRepositoryDetails(this.getById(id), id).getRepositoryURL();
    }

    public List<EIdentifierType> getPidSystems(String id) {
        return RepositoryMapper.mapToRepositoryDetails(this.getById(id), id).getPidSystems();
    }
}

