/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import jakarta.annotation.security.PermitAll;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import org.damap.base.rest.config.domain.ConfigDO;
import org.damap.base.rest.config.domain.PersonServiceConfigurations;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/api/config")
@Produces(value={"application/json"})
@PermitAll
public class ConfigResource {
    @Generated
    private static final Logger log = Logger.getLogger(ConfigResource.class);
    @ConfigProperty(name="damap.auth.frontend.url")
    String authUrl;
    @ConfigProperty(name="damap.auth.frontend.client")
    String authClient;
    @ConfigProperty(name="damap.auth.scope")
    String authScope;
    @ConfigProperty(name="damap.auth.user")
    String authUser;
    @ConfigProperty(name="damap.env")
    String env;
    @ConfigProperty(name="damap.person-services")
    PersonServiceConfigurations personServiceConfigurations;
    @ConfigProperty(name="damap.fits-url")
    Optional<URL> fitsUrl;

    @GET
    public ConfigDO config() {
        ConfigDO configDO = new ConfigDO();
        configDO.setAuthUrl(this.authUrl);
        configDO.setAuthClient(this.authClient);
        configDO.setAuthScope(this.authScope);
        configDO.setAuthUser(this.authUser);
        configDO.setEnv(this.env);
        configDO.setPersonSearchServiceConfigs(this.personServiceConfigurations.getConfigs());
        configDO.setFitsServiceAvailable(this.getFitsServiceAvailability());
        return configDO;
    }

    private boolean getFitsServiceAvailability() {
        return this.fitsUrl.isPresent();
    }
}

