/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.dmp.domain.DmpDO;
import org.damap.base.rest.dmp.domain.DmpListItemDO;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.jaxrs.PathParam;

@Path(value="/api/dmps")
@Authenticated
@Produces(value={"application/json"})
public class DataManagementPlanResource {
    @Generated
    private static final Logger log = Logger.getLogger(DataManagementPlanResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    AccessValidator accessValidator;
    @Inject
    DmpService dmpService;

    private final String unauthorizedMessage(long id) {
        return "Not authorized to access dmp with id " + id;
    }

    @GET
    @Path(value="/all")
    @RolesAllowed(value={"Damap Admin"})
    public List<DmpListItemDO> getAll() {
        log.info((Object)"Return all Dmps");
        return this.dmpService.getAll();
    }

    @GET
    @Path(value="/list")
    public List<DmpListItemDO> getDmpList() {
        log.info((Object)"Return dmp list for user");
        String personId = this.getPersonId();
        log.info((Object)("User id: " + personId));
        return this.dmpService.getDmpListByPersonId(personId);
    }

    @GET
    @Path(value="/{id}")
    public DmpDO getDmpById(@PathParam String id) {
        log.info((Object)("Return dmp with id: " + id));
        String personId = this.getPersonId();
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException(this.unauthorizedMessage(dmpId));
        }
        return this.dmpService.getDmpById(dmpId);
    }

    @POST
    @Consumes(value={"application/json"})
    public DmpDO saveDmp(@Valid DmpDO dmpDO) {
        log.info((Object)"Save dmp");
        String personId = this.getPersonId();
        return this.dmpService.create(dmpDO, personId);
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    public DmpDO updateDmp(@PathParam String id, @Valid DmpDO dmpDO) {
        log.info((Object)("Update dmp with id: " + id));
        String personId = this.getPersonId();
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canEditDmp(dmpId, personId)) {
            throw new ForbiddenException(this.unauthorizedMessage(dmpId));
        }
        return this.dmpService.update(dmpDO);
    }

    @DELETE
    @Path(value="/{id}")
    public void deleteDmp(@PathParam String id) {
        log.info((Object)("Delete dmp with id: " + id));
        String personId = this.getPersonId();
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canDeleteDmp(dmpId, personId)) {
            throw new ForbiddenException(this.unauthorizedMessage(dmpId));
        }
        this.dmpService.delete(dmpId);
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }

    @GET
    @Path(value="/{id}/{revision}")
    public DmpDO getDmpByIdAndRevision(@PathParam String id, @PathParam long revision) {
        log.info((Object)("Return dmp with id: " + id + " and revision number: " + revision));
        String personId = this.getPersonId();
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException(this.unauthorizedMessage(dmpId));
        }
        return this.dmpService.getDmpByIdAndRevision(dmpId, revision);
    }
}

