/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.damap.base.conversion.ExportTemplateBroker;
import org.damap.base.enums.ETemplateType;
import org.damap.base.rest.dmp.service.DmpService;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;

@Path(value="/api/document")
@Authenticated
@Produces(value={"application/octet-stream"})
public class DmpDocumentResource {
    @Generated
    private static final Logger log = Logger.getLogger(DmpDocumentResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    AccessValidator accessValidator;
    @Inject
    ExportTemplateBroker exportTemplateBroker;
    @Inject
    DmpService dmpService;

    @GET
    @Path(value="/{dmpId}")
    public Response exportTemplate(@PathParam(value="dmpId") long dmpId, @QueryParam(value="template") ETemplateType template) {
        log.info((Object)("Return DMP document file for DMP with id=" + dmpId));
        String personId = this.getPersonId();
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + dmpId);
        }
        String filename = this.dmpService.getDefaultFileName(dmpId);
        final XWPFDocument document = template != null ? this.exportTemplateBroker.exportTemplateByType(dmpId, template) : this.exportTemplateBroker.exportTemplate(dmpId);
        StreamingOutput streamingOutput = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                document.write(os);
                document.close();
            }
        };
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)("attachment;filename=" + filename + ".docx")).header("Access-Control-Expose-Headers", (Object)"Content-Disposition").build();
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

