/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.gdpr.domain.GdprResult;
import org.damap.base.rest.gdpr.service.GdprService;
import org.damap.base.security.SecurityService;
import org.jboss.logging.Logger;

@Path(value="api/gdpr")
@Authenticated
@Produces(value={"application/json"})
public class GdprResource {
    @Generated
    private static final Logger log = Logger.getLogger(GdprResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    GdprService gdprService;

    @GET
    public List<GdprResult> read() {
        log.info((Object)"Get GDPR base data");
        return this.gdprService.getGdprBaseData(this.getPersonId());
    }

    @GET
    @Path(value="extended")
    public List<GdprResult> readExtended() {
        log.info((Object)"Get GDPR extended data");
        return this.gdprService.getGdprExtendedData(this.getPersonId());
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

