/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest;

import io.quarkus.security.Authenticated;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.ForbiddenException;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.version.VersionDO;
import org.damap.base.rest.version.VersionService;
import org.damap.base.security.SecurityService;
import org.damap.base.validation.AccessValidator;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.jaxrs.PathParam;

@Path(value="/api/versions")
@Produces(value={"application/json"})
@Authenticated
public class VersionResource {
    @Generated
    private static final Logger log = Logger.getLogger(VersionResource.class);
    @Inject
    SecurityService securityService;
    @Inject
    AccessValidator accessValidator;
    @Inject
    VersionService versionService;

    @GET
    @Path(value="/list/{id}")
    public List<VersionDO> getDmpVersions(@PathParam String id) {
        log.debug((Object)("Return dmp versions for dmp with id: " + id));
        String personId = this.getPersonId();
        long dmpId = Long.parseLong(id);
        if (!this.accessValidator.canViewDmp(dmpId, personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + dmpId);
        }
        return this.versionService.getDmpVersions(dmpId);
    }

    @PUT
    @Consumes(value={"application/json"})
    public VersionDO saveVersion(VersionDO versionDO) {
        log.info((Object)"Save/update version");
        String personId = this.getPersonId();
        if (!this.accessValidator.canEditDmp(versionDO.getDmpId(), personId)) {
            throw new ForbiddenException("Not authorized to access dmp with id " + versionDO.getDmpId());
        }
        return this.versionService.createOrUpdate(versionDO);
    }

    private String getPersonId() {
        if (this.securityService == null) {
            throw new AuthenticationFailedException("User ID is missing.");
        }
        return this.securityService.getUserId();
    }
}

