/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.access.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.damap.base.domain.Access;
import org.damap.base.domain.Dmp;
import org.damap.base.repo.AccessRepo;
import org.damap.base.repo.DmpRepo;
import org.damap.base.rest.PersonServiceBroker;
import org.damap.base.rest.access.domain.AccessDO;
import org.damap.base.rest.access.mapper.AccessMapper;
import org.damap.base.rest.dmp.domain.ContributorDO;
import org.damap.base.rest.dmp.mapper.ContributorDOMapper;
import org.damap.base.rest.dmp.mapper.MapperService;
import org.damap.base.rest.persons.PersonService;
import org.jboss.logging.Logger;

@ApplicationScoped
public class AccessService {
    @Generated
    private static final Logger log = Logger.getLogger(AccessService.class);
    private final String ENABLED_PERSON_SERVICE = "UNIVERSITY";
    @Inject
    AccessRepo accessRepo;
    @Inject
    DmpRepo dmpRepo;
    @Inject
    MapperService mapperService;
    @Inject
    PersonServiceBroker personServiceBroker;

    public List<ContributorDO> getByDmpId(long dmpId) {
        PersonService personService = this.personServiceBroker.getServiceForQueryParam("UNIVERSITY");
        Dmp dmp = (Dmp)((Object)this.dmpRepo.findById(dmpId));
        ArrayList<ContributorDO> accessDOList = new ArrayList<ContributorDO>();
        this.accessRepo.getAccessByDmp(dmp).forEach(access -> {
            AccessDO accessDO = AccessMapper.mapEntityToDO(access, new AccessDO());
            if (accessDO.getMbox() == null) {
                ContributorDO owner = (ContributorDO)personService.read(access.getUniversityId());
                accessDO.setFirstName(owner.getFirstName());
                accessDO.setLastName(owner.getLastName());
                accessDO.setMbox(owner.getMbox());
            }
            accessDOList.add(accessDO);
        });
        dmp.getContributorList().forEach(contributor -> {
            if (contributor.getUniversityId() != null && !contributor.getUniversityId().isEmpty() && accessDOList.stream().noneMatch(a -> a.getUniversityId().equals(contributor.getUniversityId()))) {
                ContributorDO contributorDO = new ContributorDO();
                ContributorDOMapper.mapEntityToDO(contributor, contributorDO);
                contributorDO.setId(null);
                accessDOList.add(contributorDO);
            }
        });
        return accessDOList;
    }

    @Transactional
    public AccessDO create(AccessDO accessDO) {
        Access access = new Access();
        AccessMapper.mapDOtoEntity(accessDO, access, this.mapperService);
        if (access.getPersonIdentifier() != null) {
            access.getPersonIdentifier().persist();
        }
        access.setStart(new Date());
        access.persist();
        return AccessMapper.mapEntityToDO(access, new AccessDO());
    }

    @Transactional
    public void delete(long id) {
        this.accessRepo.deleteById(id);
    }
}

