/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.base;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import lombok.Generated;
import org.damap.base.rest.base.Pagination;
import org.damap.base.rest.base.Search;

public class ResultList<T> {
    private Search search;
    private List<T> items;

    public static <T> ResultList<T> fromItemsAndSearch(List<T> items, Search search) {
        ResultList<T> result = new ResultList<T>();
        result.setItems(items != null ? items : List.of());
        result.setSearch(search != null ? search : Search.fromMap((MultivaluedMap<String, String>)new MultivaluedHashMap()));
        if (result.search.getPagination() == null) {
            Pagination p = new Pagination();
            p.setNumTotalItems(result.items.size());
            result.search.setPagination(p);
        }
        result.search.getPagination().calculateFields();
        return result;
    }

    @Generated
    public ResultList() {
    }

    @Generated
    public Search getSearch() {
        return this.search;
    }

    @Generated
    public List<T> getItems() {
        return this.items;
    }

    @Generated
    public void setSearch(Search search) {
        this.search = search;
    }

    @Generated
    public void setItems(List<T> items) {
        this.items = items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultList)) {
            return false;
        }
        ResultList other = (ResultList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Search this$search = this.getSearch();
        Search other$search = other.getSearch();
        if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Search $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResultList(search=" + this.getSearch() + ", items=" + this.getItems() + ")";
    }
}

