/*
 * Decompiled with CFR 0.152.
 */
package org.damap.base.rest.madmp.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.damap.base.rest.madmp.dto.DatasetId;
import org.damap.base.rest.madmp.dto.Distribution;
import org.damap.base.rest.madmp.dto.Metadatum;
import org.damap.base.rest.madmp.dto.SecurityAndPrivacy;
import org.damap.base.rest.madmp.dto.TechnicalResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"data_quality_assurance", "dataset_id", "description", "distribution", "issued", "keyword", "language", "metadata", "personal_data", "preservation_statement", "security_and_privacy", "sensitive_data", "technical_resource", "title", "type"})
public class Dataset {
    @JsonProperty(value="data_quality_assurance")
    @JsonPropertyDescription(value="Data Quality Assurance")
    private List<String> dataQualityAssurance = new ArrayList<String>();
    @JsonProperty(value="dataset_id")
    @JsonPropertyDescription(value="Dataset ID")
    private DatasetId datasetId;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Description is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String description;
    @JsonProperty(value="distribution")
    @JsonPropertyDescription(value="To provide technical information on a specific instance of data.")
    private List<Distribution> distribution = new ArrayList<Distribution>();
    @JsonProperty(value="issued")
    @JsonPropertyDescription(value="Issued. Encoded using the relevant ISO 8601 Date and Time compliant string.")
    private String issued;
    @JsonProperty(value="keyword")
    @JsonPropertyDescription(value="Keywords")
    private List<String> keyword = new ArrayList<String>();
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="Language of the dataset expressed using ISO 639-3.")
    private Language language;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="To describe metadata standards used.")
    private List<Metadatum> metadata = new ArrayList<Metadatum>();
    @JsonProperty(value="personal_data")
    @JsonPropertyDescription(value="If any personal data is contained. Allowed values: yes, no, unknown")
    private PersonalData personalData;
    @JsonProperty(value="preservation_statement")
    @JsonPropertyDescription(value="Preservation Statement")
    private String preservationStatement;
    @JsonProperty(value="security_and_privacy")
    @JsonPropertyDescription(value="To list all issues and requirements related to security and privacy")
    private List<SecurityAndPrivacy> securityAndPrivacy = new ArrayList<SecurityAndPrivacy>();
    @JsonProperty(value="sensitive_data")
    @JsonPropertyDescription(value="If any sensitive data is contained. Allowed values: yes, no, unknown")
    private SensitiveData sensitiveData;
    @JsonProperty(value="technical_resource")
    @JsonPropertyDescription(value="To list all technical resources needed to implement a DMP")
    private List<TechnicalResource> technicalResource = new ArrayList<TechnicalResource>();
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="Title is a property in both Dataset and Distribution, in compliance with W3C DCAT. In some cases these might be identical, but in most cases the Dataset represents a more abstract concept, while the distribution can point to a specific file.")
    private String title;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="If appropriate, type according to: DataCite and/or COAR dictionary. Otherwise use the common name for the type, e.g. raw data, software, survey, etc. https://schema.datacite.org/meta/kernel-4.1/doc/DataCite-MetadataKernel_v4.1.pdf http://vocabularies.coar-repositories.org/pubby/resource_type.html")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="data_quality_assurance")
    public List<String> getDataQualityAssurance() {
        return this.dataQualityAssurance;
    }

    @JsonProperty(value="data_quality_assurance")
    public void setDataQualityAssurance(List<String> dataQualityAssurance) {
        this.dataQualityAssurance = dataQualityAssurance;
    }

    @JsonProperty(value="dataset_id")
    public DatasetId getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="dataset_id")
    public void setDatasetId(DatasetId datasetId) {
        this.datasetId = datasetId;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="distribution")
    public List<Distribution> getDistribution() {
        return this.distribution;
    }

    @JsonProperty(value="distribution")
    public void setDistribution(List<Distribution> distribution) {
        this.distribution = distribution;
    }

    @JsonProperty(value="issued")
    public String getIssued() {
        return this.issued;
    }

    @JsonProperty(value="issued")
    public void setIssued(String issued) {
        this.issued = issued;
    }

    @JsonProperty(value="keyword")
    public List<String> getKeyword() {
        return this.keyword;
    }

    @JsonProperty(value="keyword")
    public void setKeyword(List<String> keyword) {
        this.keyword = keyword;
    }

    @JsonProperty(value="language")
    public Language getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(Language language) {
        this.language = language;
    }

    @JsonProperty(value="metadata")
    public List<Metadatum> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(List<Metadatum> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="personal_data")
    public PersonalData getPersonalData() {
        return this.personalData;
    }

    @JsonProperty(value="personal_data")
    public void setPersonalData(PersonalData personalData) {
        this.personalData = personalData;
    }

    @JsonProperty(value="preservation_statement")
    public String getPreservationStatement() {
        return this.preservationStatement;
    }

    @JsonProperty(value="preservation_statement")
    public void setPreservationStatement(String preservationStatement) {
        this.preservationStatement = preservationStatement;
    }

    @JsonProperty(value="security_and_privacy")
    public List<SecurityAndPrivacy> getSecurityAndPrivacy() {
        return this.securityAndPrivacy;
    }

    @JsonProperty(value="security_and_privacy")
    public void setSecurityAndPrivacy(List<SecurityAndPrivacy> securityAndPrivacy) {
        this.securityAndPrivacy = securityAndPrivacy;
    }

    @JsonProperty(value="sensitive_data")
    public SensitiveData getSensitiveData() {
        return this.sensitiveData;
    }

    @JsonProperty(value="sensitive_data")
    public void setSensitiveData(SensitiveData sensitiveData) {
        this.sensitiveData = sensitiveData;
    }

    @JsonProperty(value="technical_resource")
    public List<TechnicalResource> getTechnicalResource() {
        return this.technicalResource;
    }

    @JsonProperty(value="technical_resource")
    public void setTechnicalResource(List<TechnicalResource> technicalResource) {
        this.technicalResource = technicalResource;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Dataset.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dataQualityAssurance");
        sb.append('=');
        sb.append(this.dataQualityAssurance == null ? "<null>" : this.dataQualityAssurance);
        sb.append(',');
        sb.append("datasetId");
        sb.append('=');
        sb.append(this.datasetId == null ? "<null>" : this.datasetId);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("distribution");
        sb.append('=');
        sb.append(this.distribution == null ? "<null>" : this.distribution);
        sb.append(',');
        sb.append("issued");
        sb.append('=');
        sb.append(this.issued == null ? "<null>" : this.issued);
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(this.keyword == null ? "<null>" : this.keyword);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("metadata");
        sb.append('=');
        sb.append(this.metadata == null ? "<null>" : this.metadata);
        sb.append(',');
        sb.append("personalData");
        sb.append('=');
        sb.append(this.personalData == null ? "<null>" : this.personalData);
        sb.append(',');
        sb.append("preservationStatement");
        sb.append('=');
        sb.append(this.preservationStatement == null ? "<null>" : this.preservationStatement);
        sb.append(',');
        sb.append("securityAndPrivacy");
        sb.append('=');
        sb.append(this.securityAndPrivacy == null ? "<null>" : this.securityAndPrivacy);
        sb.append(',');
        sb.append("sensitiveData");
        sb.append('=');
        sb.append(this.sensitiveData == null ? "<null>" : this.sensitiveData);
        sb.append(',');
        sb.append("technicalResource");
        sb.append('=');
        sb.append(this.technicalResource == null ? "<null>" : this.technicalResource);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = result * 31 + (this.securityAndPrivacy == null ? 0 : this.securityAndPrivacy.hashCode());
        result = result * 31 + (this.personalData == null ? 0 : this.personalData.hashCode());
        result = result * 31 + (this.technicalResource == null ? 0 : this.technicalResource.hashCode());
        result = result * 31 + (this.sensitiveData == null ? 0 : this.sensitiveData.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.distribution == null ? 0 : this.distribution.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.preservationStatement == null ? 0 : this.preservationStatement.hashCode());
        result = result * 31 + (this.dataQualityAssurance == null ? 0 : this.dataQualityAssurance.hashCode());
        result = result * 31 + (this.datasetId == null ? 0 : this.datasetId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.issued == null ? 0 : this.issued.hashCode());
        result = result * 31 + (this.keyword == null ? 0 : this.keyword.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Dataset)) {
            return false;
        }
        Dataset rhs = (Dataset)other;
        return (this.metadata == rhs.metadata || this.metadata != null && this.metadata.equals(rhs.metadata)) && (this.securityAndPrivacy == rhs.securityAndPrivacy || this.securityAndPrivacy != null && this.securityAndPrivacy.equals(rhs.securityAndPrivacy)) && (this.personalData == rhs.personalData || this.personalData != null && this.personalData.equals((Object)rhs.personalData)) && (this.technicalResource == rhs.technicalResource || this.technicalResource != null && this.technicalResource.equals(rhs.technicalResource)) && (this.sensitiveData == rhs.sensitiveData || this.sensitiveData != null && this.sensitiveData.equals((Object)rhs.sensitiveData)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.language == rhs.language || this.language != null && this.language.equals((Object)rhs.language)) && (this.distribution == rhs.distribution || this.distribution != null && this.distribution.equals(rhs.distribution)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.preservationStatement == rhs.preservationStatement || this.preservationStatement != null && this.preservationStatement.equals(rhs.preservationStatement)) && (this.dataQualityAssurance == rhs.dataQualityAssurance || this.dataQualityAssurance != null && this.dataQualityAssurance.equals(rhs.dataQualityAssurance)) && (this.datasetId == rhs.datasetId || this.datasetId != null && this.datasetId.equals(rhs.datasetId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.issued == rhs.issued || this.issued != null && this.issued.equals(rhs.issued)) && (this.keyword == rhs.keyword || this.keyword != null && this.keyword.equals(rhs.keyword));
    }

    public static enum Language {
        AAR("aar"),
        ABK("abk"),
        AFR("afr"),
        AKA("aka"),
        AMH("amh"),
        ARA("ara"),
        ARG("arg"),
        ASM("asm"),
        AVA("ava"),
        AVE("ave"),
        AYM("aym"),
        AZE("aze"),
        BAK("bak"),
        BAM("bam"),
        BEL("bel"),
        BEN("ben"),
        BIH("bih"),
        BIS("bis"),
        BOD("bod"),
        BOS("bos"),
        BRE("bre"),
        BUL("bul"),
        CAT("cat"),
        CES("ces"),
        CHA("cha"),
        CHE("che"),
        CHU("chu"),
        CHV("chv"),
        COR("cor"),
        COS("cos"),
        CRE("cre"),
        CYM("cym"),
        DAN("dan"),
        DEU("deu"),
        DIV("div"),
        DZO("dzo"),
        ELL("ell"),
        ENG("eng"),
        EPO("epo"),
        EST("est"),
        EUS("eus"),
        EWE("ewe"),
        FAO("fao"),
        FAS("fas"),
        FIJ("fij"),
        FIN("fin"),
        FRA("fra"),
        FRY("fry"),
        FUL("ful"),
        GLA("gla"),
        GLE("gle"),
        GLG("glg"),
        GLV("glv"),
        GRN("grn"),
        GUJ("guj"),
        HAT("hat"),
        HAU("hau"),
        HBS("hbs"),
        HEB("heb"),
        HER("her"),
        HIN("hin"),
        HMO("hmo"),
        HRV("hrv"),
        HUN("hun"),
        HYE("hye"),
        IBO("ibo"),
        IDO("ido"),
        III("iii"),
        IKU("iku"),
        ILE("ile"),
        INA("ina"),
        IND("ind"),
        IPK("ipk"),
        ISL("isl"),
        ITA("ita"),
        JAV("jav"),
        JPN("jpn"),
        KAL("kal"),
        KAN("kan"),
        KAS("kas"),
        KAT("kat"),
        KAU("kau"),
        KAZ("kaz"),
        KHM("khm"),
        KIK("kik"),
        KIN("kin"),
        KIR("kir"),
        KOM("kom"),
        KON("kon"),
        KOR("kor"),
        KUA("kua"),
        KUR("kur"),
        LAO("lao"),
        LAT("lat"),
        LAV("lav"),
        LIM("lim"),
        LIN("lin"),
        LIT("lit"),
        LTZ("ltz"),
        LUB("lub"),
        LUG("lug"),
        MAH("mah"),
        MAL("mal"),
        MAR("mar"),
        MKD("mkd"),
        MLG("mlg"),
        MLT("mlt"),
        MON("mon"),
        MRI("mri"),
        MSA("msa"),
        MYA("mya"),
        NAU("nau"),
        NAV("nav"),
        NBL("nbl"),
        NDE("nde"),
        NDO("ndo"),
        NEP("nep"),
        NLD("nld"),
        NNO("nno"),
        NOB("nob"),
        NOR("nor"),
        NYA("nya"),
        OCI("oci"),
        OJI("oji"),
        ORI("ori"),
        ORM("orm"),
        OSS("oss"),
        PAN("pan"),
        PLI("pli"),
        POL("pol"),
        POR("por"),
        PUS("pus"),
        QUE("que"),
        ROH("roh"),
        RON("ron"),
        RUN("run"),
        RUS("rus"),
        SAG("sag"),
        SAN("san"),
        SIN("sin"),
        SLK("slk"),
        SLV("slv"),
        SME("sme"),
        SMO("smo"),
        SNA("sna"),
        SND("snd"),
        SOM("som"),
        SOT("sot"),
        SPA("spa"),
        SQI("sqi"),
        SRD("srd"),
        SRP("srp"),
        SSW("ssw"),
        SUN("sun"),
        SWA("swa"),
        SWE("swe"),
        TAH("tah"),
        TAM("tam"),
        TAT("tat"),
        TEL("tel"),
        TGK("tgk"),
        TGL("tgl"),
        THA("tha"),
        TIR("tir"),
        TON("ton"),
        TSN("tsn"),
        TSO("tso"),
        TUK("tuk"),
        TUR("tur"),
        TWI("twi"),
        UIG("uig"),
        UKR("ukr"),
        URD("urd"),
        UZB("uzb"),
        VEN("ven"),
        VIE("vie"),
        VOL("vol"),
        WLN("wln"),
        WOL("wol"),
        XHO("xho"),
        YID("yid"),
        YOR("yor"),
        ZHA("zha"),
        ZHO("zho"),
        ZUL("zul");

        private final String value;
        private static final Map<String, Language> CONSTANTS;

        private Language(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Language fromValue(String value) {
            Language constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Language>();
            for (Language c : Language.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PersonalData {
        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");

        private final String value;
        private static final Map<String, PersonalData> CONSTANTS;

        private PersonalData(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PersonalData fromValue(String value) {
            PersonalData constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PersonalData>();
            for (PersonalData c : PersonalData.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SensitiveData {
        YES("yes"),
        NO("no"),
        UNKNOWN("unknown");

        private final String value;
        private static final Map<String, SensitiveData> CONSTANTS;

        private SensitiveData(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SensitiveData fromValue(String value) {
            SensitiveData constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, SensitiveData>();
            for (SensitiveData c : SensitiveData.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

